// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Specifies the TLS configuration for an integration.
 */
public class TlsConfig private constructor(builder: Builder) {
    /**
     * Specifies whether or not API Gateway skips verification that the certificate for an integration endpoint is issued by a supported certificate authority. This isn’t recommended, but it enables you to use certificates that are signed by private certificate authorities, or certificates that are self-signed. If enabled, API Gateway still performs basic certificate validation, which includes checking the certificate's expiration date, hostname, and presence of a root certificate authority. Supported only for `HTTP` and `HTTP_PROXY` integrations.
     *
     * Enabling `insecureSkipVerification` isn't recommended, especially for integrations with public HTTPS endpoints. If you enable `insecureSkipVerification`, you increase the risk of man-in-the-middle attacks.
     */
    public val insecureSkipVerification: kotlin.Boolean = builder.insecureSkipVerification

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.TlsConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TlsConfig(")
        append("insecureSkipVerification=$insecureSkipVerification")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = insecureSkipVerification.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TlsConfig

        if (insecureSkipVerification != other.insecureSkipVerification) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.TlsConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether or not API Gateway skips verification that the certificate for an integration endpoint is issued by a supported certificate authority. This isn’t recommended, but it enables you to use certificates that are signed by private certificate authorities, or certificates that are self-signed. If enabled, API Gateway still performs basic certificate validation, which includes checking the certificate's expiration date, hostname, and presence of a root certificate authority. Supported only for `HTTP` and `HTTP_PROXY` integrations.
         *
         * Enabling `insecureSkipVerification` isn't recommended, especially for integrations with public HTTPS endpoints. If you enable `insecureSkipVerification`, you increase the risk of man-in-the-middle attacks.
         */
        public var insecureSkipVerification: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.TlsConfig) : this() {
            this.insecureSkipVerification = x.insecureSkipVerification
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.TlsConfig = TlsConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
