// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Sets up a method's integration.
 */
public class PutIntegrationRequest private constructor(builder: Builder) {
    /**
     * A list of request parameters whose values API Gateway caches. To be valid values for `cacheKeyParameters`, these parameters must also be specified for Method `requestParameters`.
     */
    public val cacheKeyParameters: List<String>? = builder.cacheKeyParameters
    /**
     * Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the `cacheNamespace`. You can specify the same `cacheNamespace` across resources to return the same cached data for requests to different resources.
     */
    public val cacheNamespace: kotlin.String? = builder.cacheNamespace
    /**
     * The ID of the VpcLink used for the integration. Specify this value only if you specify `VPC_LINK` as the connection type.
     */
    public val connectionId: kotlin.String? = builder.connectionId
    /**
     * The type of the network connection to the integration endpoint. The valid value is `INTERNET` for connections through the public routable internet or `VPC_LINK` for private connections between API Gateway and a network load balancer in a VPC. The default value is `INTERNET`.
     */
    public val connectionType: aws.sdk.kotlin.services.apigateway.model.ConnectionType? = builder.connectionType
    /**
     * Specifies how to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`, with the following behaviors:
     *
     * If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the `passthroughBehavior` is configured to support payload pass-through.
     */
    public val contentHandling: aws.sdk.kotlin.services.apigateway.model.ContentHandlingStrategy? = builder.contentHandling
    /**
     * Specifies whether credentials are required for a put integration.
     */
    public val credentials: kotlin.String? = builder.credentials
    /**
     * Specifies the HTTP method for the integration.
     */
    public val httpMethod: kotlin.String? = builder.httpMethod
    /**
     * The HTTP method for the integration.
     */
    public val integrationHttpMethod: kotlin.String? = builder.integrationHttpMethod
    /**
     * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the `requestTemplates` property on the Integration resource. There are three valid values: `WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, and `NEVER`.
     */
    public val passthroughBehavior: kotlin.String? = builder.passthroughBehavior
    /**
     * A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of `method.request.{location}.{name}`, where `location` is `querystring`, `path`, or `header` and `name` must be a valid and unique method request parameter name.
     */
    public val requestParameters: Map<String, String>? = builder.requestParameters
    /**
     * Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.
     */
    public val requestTemplates: Map<String, String>? = builder.requestTemplates
    /**
     * Specifies a put integration request's resource ID.
     */
    public val resourceId: kotlin.String? = builder.resourceId
    /**
     * The string identifier of the associated RestApi.
     */
    public val restApiId: kotlin.String? = builder.restApiId
    /**
     * Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.
     */
    public val timeoutInMillis: kotlin.Int? = builder.timeoutInMillis
    /**
     * Specifies the TLS configuration for an integration.
     */
    public val tlsConfig: aws.sdk.kotlin.services.apigateway.model.TlsConfig? = builder.tlsConfig
    /**
     * Specifies a put integration input's type.
     */
    public val type: aws.sdk.kotlin.services.apigateway.model.IntegrationType? = builder.type
    /**
     * Specifies Uniform Resource Identifier (URI) of the integration endpoint. For HTTP or `HTTP_PROXY` integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification, for either standard integration, where `connectionType` is not `VPC_LINK`, or private integration, where `connectionType` is `VPC_LINK`. For a private HTTP integration, the URI is not used for routing. For `AWS` or `AWS_PROXY` integrations, the URI is of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api`}. Here, {Region} is the API Gateway region (e.g., us-east-1); {service} is the name of the integrated Amazon Web Services service (e.g., s3); and {subdomain} is a designated subdomain supported by certain Amazon Web Services service for fast host-name lookup. action can be used for an Amazon Web Services service action-based API, using an Action={name}&{p1}={v1}&p2={v2}... query string. The ensuing {service_api} refers to a supported action {name} plus any required input parameters. Alternatively, path can be used for an Amazon Web Services service path-based API. The ensuing service_api refers to the path to an Amazon Web Services service resource, including the region of the integrated Amazon Web Services service, if applicable. For example, for integration with the S3 API of `GetObject`, the `uri` can be either `arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}` or `arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}`.
     */
    public val uri: kotlin.String? = builder.uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.PutIntegrationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutIntegrationRequest(")
        append("cacheKeyParameters=$cacheKeyParameters,")
        append("cacheNamespace=$cacheNamespace,")
        append("connectionId=$connectionId,")
        append("connectionType=$connectionType,")
        append("contentHandling=$contentHandling,")
        append("credentials=$credentials,")
        append("httpMethod=$httpMethod,")
        append("integrationHttpMethod=$integrationHttpMethod,")
        append("passthroughBehavior=$passthroughBehavior,")
        append("requestParameters=$requestParameters,")
        append("requestTemplates=$requestTemplates,")
        append("resourceId=$resourceId,")
        append("restApiId=$restApiId,")
        append("timeoutInMillis=$timeoutInMillis,")
        append("tlsConfig=$tlsConfig,")
        append("type=$type,")
        append("uri=$uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheKeyParameters?.hashCode() ?: 0
        result = 31 * result + (cacheNamespace?.hashCode() ?: 0)
        result = 31 * result + (connectionId?.hashCode() ?: 0)
        result = 31 * result + (connectionType?.hashCode() ?: 0)
        result = 31 * result + (contentHandling?.hashCode() ?: 0)
        result = 31 * result + (credentials?.hashCode() ?: 0)
        result = 31 * result + (httpMethod?.hashCode() ?: 0)
        result = 31 * result + (integrationHttpMethod?.hashCode() ?: 0)
        result = 31 * result + (passthroughBehavior?.hashCode() ?: 0)
        result = 31 * result + (requestParameters?.hashCode() ?: 0)
        result = 31 * result + (requestTemplates?.hashCode() ?: 0)
        result = 31 * result + (resourceId?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (timeoutInMillis ?: 0)
        result = 31 * result + (tlsConfig?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        result = 31 * result + (uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutIntegrationRequest

        if (cacheKeyParameters != other.cacheKeyParameters) return false
        if (cacheNamespace != other.cacheNamespace) return false
        if (connectionId != other.connectionId) return false
        if (connectionType != other.connectionType) return false
        if (contentHandling != other.contentHandling) return false
        if (credentials != other.credentials) return false
        if (httpMethod != other.httpMethod) return false
        if (integrationHttpMethod != other.integrationHttpMethod) return false
        if (passthroughBehavior != other.passthroughBehavior) return false
        if (requestParameters != other.requestParameters) return false
        if (requestTemplates != other.requestTemplates) return false
        if (resourceId != other.resourceId) return false
        if (restApiId != other.restApiId) return false
        if (timeoutInMillis != other.timeoutInMillis) return false
        if (tlsConfig != other.tlsConfig) return false
        if (type != other.type) return false
        if (uri != other.uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.PutIntegrationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A list of request parameters whose values API Gateway caches. To be valid values for `cacheKeyParameters`, these parameters must also be specified for Method `requestParameters`.
         */
        public var cacheKeyParameters: List<String>? = null
        /**
         * Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the `cacheNamespace`. You can specify the same `cacheNamespace` across resources to return the same cached data for requests to different resources.
         */
        public var cacheNamespace: kotlin.String? = null
        /**
         * The ID of the VpcLink used for the integration. Specify this value only if you specify `VPC_LINK` as the connection type.
         */
        public var connectionId: kotlin.String? = null
        /**
         * The type of the network connection to the integration endpoint. The valid value is `INTERNET` for connections through the public routable internet or `VPC_LINK` for private connections between API Gateway and a network load balancer in a VPC. The default value is `INTERNET`.
         */
        public var connectionType: aws.sdk.kotlin.services.apigateway.model.ConnectionType? = null
        /**
         * Specifies how to handle request payload content type conversions. Supported values are `CONVERT_TO_BINARY` and `CONVERT_TO_TEXT`, with the following behaviors:
         *
         * If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the `passthroughBehavior` is configured to support payload pass-through.
         */
        public var contentHandling: aws.sdk.kotlin.services.apigateway.model.ContentHandlingStrategy? = null
        /**
         * Specifies whether credentials are required for a put integration.
         */
        public var credentials: kotlin.String? = null
        /**
         * Specifies the HTTP method for the integration.
         */
        public var httpMethod: kotlin.String? = null
        /**
         * The HTTP method for the integration.
         */
        public var integrationHttpMethod: kotlin.String? = null
        /**
         * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the `requestTemplates` property on the Integration resource. There are three valid values: `WHEN_NO_MATCH`, `WHEN_NO_TEMPLATES`, and `NEVER`.
         */
        public var passthroughBehavior: kotlin.String? = null
        /**
         * A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of `method.request.{location}.{name}`, where `location` is `querystring`, `path`, or `header` and `name` must be a valid and unique method request parameter name.
         */
        public var requestParameters: Map<String, String>? = null
        /**
         * Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value.
         */
        public var requestTemplates: Map<String, String>? = null
        /**
         * Specifies a put integration request's resource ID.
         */
        public var resourceId: kotlin.String? = null
        /**
         * The string identifier of the associated RestApi.
         */
        public var restApiId: kotlin.String? = null
        /**
         * Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds.
         */
        public var timeoutInMillis: kotlin.Int? = null
        /**
         * Specifies the TLS configuration for an integration.
         */
        public var tlsConfig: aws.sdk.kotlin.services.apigateway.model.TlsConfig? = null
        /**
         * Specifies a put integration input's type.
         */
        public var type: aws.sdk.kotlin.services.apigateway.model.IntegrationType? = null
        /**
         * Specifies Uniform Resource Identifier (URI) of the integration endpoint. For HTTP or `HTTP_PROXY` integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification, for either standard integration, where `connectionType` is not `VPC_LINK`, or private integration, where `connectionType` is `VPC_LINK`. For a private HTTP integration, the URI is not used for routing. For `AWS` or `AWS_PROXY` integrations, the URI is of the form `arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api`}. Here, {Region} is the API Gateway region (e.g., us-east-1); {service} is the name of the integrated Amazon Web Services service (e.g., s3); and {subdomain} is a designated subdomain supported by certain Amazon Web Services service for fast host-name lookup. action can be used for an Amazon Web Services service action-based API, using an Action={name}&{p1}={v1}&p2={v2}... query string. The ensuing {service_api} refers to a supported action {name} plus any required input parameters. Alternatively, path can be used for an Amazon Web Services service path-based API. The ensuing service_api refers to the path to an Amazon Web Services service resource, including the region of the integrated Amazon Web Services service, if applicable. For example, for integration with the S3 API of `GetObject`, the `uri` can be either `arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}` or `arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}`.
         */
        public var uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.PutIntegrationRequest) : this() {
            this.cacheKeyParameters = x.cacheKeyParameters
            this.cacheNamespace = x.cacheNamespace
            this.connectionId = x.connectionId
            this.connectionType = x.connectionType
            this.contentHandling = x.contentHandling
            this.credentials = x.credentials
            this.httpMethod = x.httpMethod
            this.integrationHttpMethod = x.integrationHttpMethod
            this.passthroughBehavior = x.passthroughBehavior
            this.requestParameters = x.requestParameters
            this.requestTemplates = x.requestTemplates
            this.resourceId = x.resourceId
            this.restApiId = x.restApiId
            this.timeoutInMillis = x.timeoutInMillis
            this.tlsConfig = x.tlsConfig
            this.type = x.type
            this.uri = x.uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.PutIntegrationRequest = PutIntegrationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.TlsConfig] inside the given [block]
         */
        public fun tlsConfig(block: aws.sdk.kotlin.services.apigateway.model.TlsConfig.Builder.() -> kotlin.Unit) {
            this.tlsConfig = aws.sdk.kotlin.services.apigateway.model.TlsConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
