// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Request a new export of a RestApi for a particular Stage.
 */
public class GetExportRequest private constructor(builder: Builder) {
    /**
     * The content-type of the export, for example `application/json`. Currently `application/json` and `application/yaml` are supported for `exportType` of`oas30` and `swagger`. This should be specified in the `Accept` header for direct API requests.
     */
    public val accepts: kotlin.String? = builder.accepts
    /**
     * The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for Swagger/OpenAPI 2.0.
     */
    public val exportType: kotlin.String? = builder.exportType
    /**
     * A key-value map of query string parameters that specify properties of the export, depending on the requested `exportType`. For `exportType``oas30` and `swagger`, any combination of the following parameters are supported: `extensions='integrations'` or `extensions='apigateway'` will export the API with x-amazon-apigateway-integration extensions. `extensions='authorizers'` will export the API with x-amazon-apigateway-authorizer extensions. `postman` will export the API with Postman extensions, allowing for import to the Postman tool
     */
    public val parameters: Map<String, String>? = builder.parameters
    /**
     * The string identifier of the associated RestApi.
     */
    public val restApiId: kotlin.String? = builder.restApiId
    /**
     * The name of the Stage that will be exported.
     */
    public val stageName: kotlin.String? = builder.stageName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.GetExportRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetExportRequest(")
        append("accepts=$accepts,")
        append("exportType=$exportType,")
        append("parameters=$parameters,")
        append("restApiId=$restApiId,")
        append("stageName=$stageName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accepts?.hashCode() ?: 0
        result = 31 * result + (exportType?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (stageName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetExportRequest

        if (accepts != other.accepts) return false
        if (exportType != other.exportType) return false
        if (parameters != other.parameters) return false
        if (restApiId != other.restApiId) return false
        if (stageName != other.stageName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.GetExportRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The content-type of the export, for example `application/json`. Currently `application/json` and `application/yaml` are supported for `exportType` of`oas30` and `swagger`. This should be specified in the `Accept` header for direct API requests.
         */
        public var accepts: kotlin.String? = null
        /**
         * The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for Swagger/OpenAPI 2.0.
         */
        public var exportType: kotlin.String? = null
        /**
         * A key-value map of query string parameters that specify properties of the export, depending on the requested `exportType`. For `exportType``oas30` and `swagger`, any combination of the following parameters are supported: `extensions='integrations'` or `extensions='apigateway'` will export the API with x-amazon-apigateway-integration extensions. `extensions='authorizers'` will export the API with x-amazon-apigateway-authorizer extensions. `postman` will export the API with Postman extensions, allowing for import to the Postman tool
         */
        public var parameters: Map<String, String>? = null
        /**
         * The string identifier of the associated RestApi.
         */
        public var restApiId: kotlin.String? = null
        /**
         * The name of the Stage that will be exported.
         */
        public var stageName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.GetExportRequest) : this() {
            this.accepts = x.accepts
            this.exportType = x.exportType
            this.parameters = x.parameters
            this.restApiId = x.restApiId
            this.stageName = x.stageName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.GetExportRequest = GetExportRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
