// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.serde

import aws.sdk.kotlin.services.apigateway.model.PatchOperation
import aws.sdk.kotlin.services.apigateway.model.UpdateRestApiRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateRestApiOperationSerializer: HttpSerialize<UpdateRestApiRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateRestApiRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PATCH

        builder.url {
            requireNotNull(input.restApiId) { "restApiId is bound to the URI and must not be null" }
            val pathSegments = listOf<String>(
                "restapis",
                "${input.restApiId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateRestApiOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateRestApiOperationBody(context: ExecutionContext, input: UpdateRestApiRequest): ByteArray {
    val serializer = JsonSerializer()
    val PATCHOPERATIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("patchOperations"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PATCHOPERATIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.patchOperations != null) {
            listField(PATCHOPERATIONS_DESCRIPTOR) {
                for (el0 in input.patchOperations) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializePatchOperationDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
