// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.serde

import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.TestInvokeAuthorizerResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class TestInvokeAuthorizerOperationDeserializer: HttpDeserialize<TestInvokeAuthorizerResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): TestInvokeAuthorizerResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwTestInvokeAuthorizerError(context, call)
        }
        val builder = TestInvokeAuthorizerResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeTestInvokeAuthorizerOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwTestInvokeAuthorizerError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ApiGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeTestInvokeAuthorizerOperationBody(builder: TestInvokeAuthorizerResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val AUTHORIZATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("authorization"))
    val AUTHORIZATION_C0_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List)
    val CLAIMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("claims"))
    val CLIENTSTATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("clientStatus"))
    val LATENCY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Long, JsonSerialName("latency"))
    val LOG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("log"))
    val POLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("policy"))
    val PRINCIPALID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("principalId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AUTHORIZATION_DESCRIPTOR)
        field(CLAIMS_DESCRIPTOR)
        field(CLIENTSTATUS_DESCRIPTOR)
        field(LATENCY_DESCRIPTOR)
        field(LOG_DESCRIPTOR)
        field(POLICY_DESCRIPTOR)
        field(PRINCIPALID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                AUTHORIZATION_DESCRIPTOR.index -> builder.authorization =
                    deserializer.deserializeMap(AUTHORIZATION_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, List<String>>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 =
                                if (nextHasValue()) {
                                    deserializer.deserializeList(AUTHORIZATION_C0_DESCRIPTOR) {
                                        val col1 = mutableListOf<String>()
                                        while (hasNextElement()) {
                                            val el1 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                                            col1.add(el1)
                                        }
                                        col1
                                    }
                                } else { deserializeNull(); continue }

                            map0[k0] = v0
                        }
                        map0
                    }
                CLAIMS_DESCRIPTOR.index -> builder.claims =
                    deserializer.deserializeMap(CLAIMS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                CLIENTSTATUS_DESCRIPTOR.index -> builder.clientStatus = deserializeInt()
                LATENCY_DESCRIPTOR.index -> builder.latency = deserializeLong()
                LOG_DESCRIPTOR.index -> builder.log = deserializeString()
                POLICY_DESCRIPTOR.index -> builder.policy = deserializeString()
                PRINCIPALID_DESCRIPTOR.index -> builder.principalId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
