// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.serde

import aws.sdk.kotlin.services.apigateway.model.GetSdkRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.net.parameters
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class GetSdkOperationSerializer: HttpSerialize<GetSdkRequest> {
    override suspend fun serialize(context: ExecutionContext, input: GetSdkRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.GET

        builder.url {
            requireNotNull(input.restApiId) { "restApiId is bound to the URI and must not be null" }
            requireNotNull(input.stageName) { "stageName is bound to the URI and must not be null" }
            requireNotNull(input.sdkType) { "sdkType is bound to the URI and must not be null" }
            val pathSegments = listOf<String>(
                "restapis",
                "${input.restApiId}".encodeLabel(),
                "stages",
                "${input.stageName}".encodeLabel(),
                "sdks",
                "${input.sdkType}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
            parameters {
                input.parameters
                    ?.filterNot{ contains(it.key) }
                    ?.forEach { (key, value) ->
                        append(key, value)
                    }
            }
        }

        return builder
    }
}
