// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.serde

import aws.sdk.kotlin.services.apigateway.model.ApiKeySourceType
import aws.sdk.kotlin.services.apigateway.model.CreateRestApiRequest
import aws.sdk.kotlin.services.apigateway.model.EndpointConfiguration
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateRestApiOperationSerializer: HttpSerialize<CreateRestApiRequest> {
    override suspend fun serialize(context: ExecutionContext, input: CreateRestApiRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path = "/restapis"
        }

        val payload = serializeCreateRestApiOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateRestApiOperationBody(context: ExecutionContext, input: CreateRestApiRequest): ByteArray {
    val serializer = JsonSerializer()
    val APIKEYSOURCE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("apiKeySource"))
    val BINARYMEDIATYPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("binaryMediaTypes"))
    val CLONEFROM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("cloneFrom"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DISABLEEXECUTEAPIENDPOINT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("disableExecuteApiEndpoint"))
    val ENDPOINTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("endpointConfiguration"))
    val MINIMUMCOMPRESSIONSIZE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("minimumCompressionSize"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val POLICY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("policy"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val VERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("version"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIKEYSOURCE_DESCRIPTOR)
        field(BINARYMEDIATYPES_DESCRIPTOR)
        field(CLONEFROM_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DISABLEEXECUTEAPIENDPOINT_DESCRIPTOR)
        field(ENDPOINTCONFIGURATION_DESCRIPTOR)
        field(MINIMUMCOMPRESSIONSIZE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(POLICY_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VERSION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.apiKeySource?.let { field(APIKEYSOURCE_DESCRIPTOR, it.value) }
        if (input.binaryMediaTypes != null) {
            listField(BINARYMEDIATYPES_DESCRIPTOR) {
                for (el0 in input.binaryMediaTypes) {
                    serializeString(el0)
                }
            }
        }
        input.cloneFrom?.let { field(CLONEFROM_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.disableExecuteApiEndpoint?.let { field(DISABLEEXECUTEAPIENDPOINT_DESCRIPTOR, it) }
        input.endpointConfiguration?.let { field(ENDPOINTCONFIGURATION_DESCRIPTOR, it, ::serializeEndpointConfigurationDocument) }
        input.minimumCompressionSize?.let { field(MINIMUMCOMPRESSIONSIZE_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.policy?.let { field(POLICY_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.version?.let { field(VERSION_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
