// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * The PATCH request to grant a temporary extension to the remaining quota of a usage plan associated with a specified API key.
 */
public class UpdateUsageRequest private constructor(builder: Builder) {
    /**
     * The identifier of the API key associated with the usage plan in which a temporary extension is granted to the remaining quota.
     */
    public val keyId: kotlin.String? = builder.keyId
    /**
     * For more information about supported patch operations, see [Patch Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
     */
    public val patchOperations: List<PatchOperation>? = builder.patchOperations
    /**
     * The Id of the usage plan associated with the usage data.
     */
    public val usagePlanId: kotlin.String? = builder.usagePlanId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.UpdateUsageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateUsageRequest(")
        append("keyId=$keyId,")
        append("patchOperations=$patchOperations,")
        append("usagePlanId=$usagePlanId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = keyId?.hashCode() ?: 0
        result = 31 * result + (patchOperations?.hashCode() ?: 0)
        result = 31 * result + (usagePlanId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateUsageRequest

        if (keyId != other.keyId) return false
        if (patchOperations != other.patchOperations) return false
        if (usagePlanId != other.usagePlanId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.UpdateUsageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the API key associated with the usage plan in which a temporary extension is granted to the remaining quota.
         */
        public var keyId: kotlin.String? = null
        /**
         * For more information about supported patch operations, see [Patch Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
         */
        public var patchOperations: List<PatchOperation>? = null
        /**
         * The Id of the usage plan associated with the usage data.
         */
        public var usagePlanId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.UpdateUsageRequest) : this() {
            this.keyId = x.keyId
            this.patchOperations = x.patchOperations
            this.usagePlanId = x.usagePlanId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.UpdateUsageRequest = UpdateUsageRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
