// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents a method response of a given HTTP status code returned to the client. The method response is passed from the back end through the associated integration response that can be transformed using a mapping template.
 */
public class UpdateMethodResponseResponse private constructor(builder: Builder) {
    /**
     * Specifies the Model resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a Model name as the value.
     */
    public val responseModels: Map<String, String>? = builder.responseModels
    /**
     * A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern `method.response.header.{name}`, where `name` is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's IntegrationResponse. The integration response data that can be mapped include an integration response header expressed in `integration.response.header.{name}`, a static value enclosed within a pair of single quotes (e.g., `'application/json'`), or a JSON expression from the back-end response payload in the form of `integration.response.body.{JSON-expression}`, where `JSON-expression` is a valid JSON expression without the `$` prefix.)
     */
    public val responseParameters: Map<String, Boolean>? = builder.responseParameters
    /**
     * The method response's status code.
     */
    public val statusCode: kotlin.String? = builder.statusCode

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.UpdateMethodResponseResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateMethodResponseResponse(")
        append("responseModels=$responseModels,")
        append("responseParameters=$responseParameters,")
        append("statusCode=$statusCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = responseModels?.hashCode() ?: 0
        result = 31 * result + (responseParameters?.hashCode() ?: 0)
        result = 31 * result + (statusCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateMethodResponseResponse

        if (responseModels != other.responseModels) return false
        if (responseParameters != other.responseParameters) return false
        if (statusCode != other.statusCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.UpdateMethodResponseResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the Model resources used for the response's content-type. Response models are represented as a key/value map, with a content-type as the key and a Model name as the value.
         */
        public var responseModels: Map<String, String>? = null
        /**
         * A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header and the value specifies whether the associated method response header is required or not. The expression of the key must match the pattern `method.response.header.{name}`, where `name` is a valid and unique header name. API Gateway passes certain integration response data to the method response headers specified here according to the mapping you prescribe in the API's IntegrationResponse. The integration response data that can be mapped include an integration response header expressed in `integration.response.header.{name}`, a static value enclosed within a pair of single quotes (e.g., `'application/json'`), or a JSON expression from the back-end response payload in the form of `integration.response.body.{JSON-expression}`, where `JSON-expression` is a valid JSON expression without the `$` prefix.)
         */
        public var responseParameters: Map<String, Boolean>? = null
        /**
         * The method response's status code.
         */
        public var statusCode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.UpdateMethodResponseResponse) : this() {
            this.responseModels = x.responseModels
            this.responseParameters = x.responseParameters
            this.statusCode = x.statusCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.UpdateMethodResponseResponse = UpdateMethodResponseResponse(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
