// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * The mutual TLS authentication configuration for a custom domain name. If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your API.
 */
public class MutualTlsAuthentication private constructor(builder: Builder) {
    /**
     * An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example `s3://bucket-name/key-name`. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.
     */
    public val truststoreUri: kotlin.String? = builder.truststoreUri
    /**
     * The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.
     */
    public val truststoreVersion: kotlin.String? = builder.truststoreVersion
    /**
     * A list of warnings that API Gateway returns while processing your truststore. Invalid certificates produce warnings. Mutual TLS is still enabled, but some clients might not be able to access your API. To resolve warnings, upload a new truststore to S3, and then update you domain name to use the new version.
     */
    public val truststoreWarnings: List<String>? = builder.truststoreWarnings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.MutualTlsAuthentication = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MutualTlsAuthentication(")
        append("truststoreUri=$truststoreUri,")
        append("truststoreVersion=$truststoreVersion,")
        append("truststoreWarnings=$truststoreWarnings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = truststoreUri?.hashCode() ?: 0
        result = 31 * result + (truststoreVersion?.hashCode() ?: 0)
        result = 31 * result + (truststoreWarnings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MutualTlsAuthentication

        if (truststoreUri != other.truststoreUri) return false
        if (truststoreVersion != other.truststoreVersion) return false
        if (truststoreWarnings != other.truststoreWarnings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.MutualTlsAuthentication = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An Amazon S3 URL that specifies the truststore for mutual TLS authentication, for example `s3://bucket-name/key-name`. The truststore can contain certificates from public or private certificate authorities. To update the truststore, upload a new version to S3, and then update your custom domain name to use the new version. To update the truststore, you must have permissions to access the S3 object.
         */
        public var truststoreUri: kotlin.String? = null
        /**
         * The version of the S3 object that contains your truststore. To specify a version, you must have versioning enabled for the S3 bucket.
         */
        public var truststoreVersion: kotlin.String? = null
        /**
         * A list of warnings that API Gateway returns while processing your truststore. Invalid certificates produce warnings. Mutual TLS is still enabled, but some clients might not be able to access your API. To resolve warnings, upload a new truststore to S3, and then update you domain name to use the new version.
         */
        public var truststoreWarnings: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.MutualTlsAuthentication) : this() {
            this.truststoreUri = x.truststoreUri
            this.truststoreVersion = x.truststoreVersion
            this.truststoreWarnings = x.truststoreWarnings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.MutualTlsAuthentication = MutualTlsAuthentication(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
