// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Specifies the method setting properties.
 */
public class MethodSetting private constructor(builder: Builder) {
    /**
     * Specifies whether the cached responses are encrypted.
     */
    public val cacheDataEncrypted: kotlin.Boolean = builder.cacheDataEncrypted
    /**
     * Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached.
     */
    public val cacheTtlInSeconds: kotlin.Int = builder.cacheTtlInSeconds
    /**
     * Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached.
     */
    public val cachingEnabled: kotlin.Boolean = builder.cachingEnabled
    /**
     * Specifies whether data trace logging is enabled for this method, which affects the log entries pushed to Amazon CloudWatch Logs.
     */
    public val dataTraceEnabled: kotlin.Boolean = builder.dataTraceEnabled
    /**
     * Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs. Valid values are `OFF`, `ERROR`, and `INFO`. Choose `ERROR` to write only error-level entries to CloudWatch Logs, or choose `INFO` to include all `ERROR` events as well as extra informational events.
     */
    public val loggingLevel: kotlin.String? = builder.loggingLevel
    /**
     * Specifies whether Amazon CloudWatch metrics are enabled for this method.
     */
    public val metricsEnabled: kotlin.Boolean = builder.metricsEnabled
    /**
     * Specifies whether authorization is required for a cache invalidation request.
     */
    public val requireAuthorizationForCacheControl: kotlin.Boolean = builder.requireAuthorizationForCacheControl
    /**
     * Specifies the throttling burst limit.
     */
    public val throttlingBurstLimit: kotlin.Int = builder.throttlingBurstLimit
    /**
     * Specifies the throttling rate limit.
     */
    public val throttlingRateLimit: kotlin.Double = builder.throttlingRateLimit
    /**
     * Specifies how to handle unauthorized requests for cache invalidation.
     */
    public val unauthorizedCacheControlHeaderStrategy: aws.sdk.kotlin.services.apigateway.model.UnauthorizedCacheControlHeaderStrategy? = builder.unauthorizedCacheControlHeaderStrategy

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.MethodSetting = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("MethodSetting(")
        append("cacheDataEncrypted=$cacheDataEncrypted,")
        append("cacheTtlInSeconds=$cacheTtlInSeconds,")
        append("cachingEnabled=$cachingEnabled,")
        append("dataTraceEnabled=$dataTraceEnabled,")
        append("loggingLevel=$loggingLevel,")
        append("metricsEnabled=$metricsEnabled,")
        append("requireAuthorizationForCacheControl=$requireAuthorizationForCacheControl,")
        append("throttlingBurstLimit=$throttlingBurstLimit,")
        append("throttlingRateLimit=$throttlingRateLimit,")
        append("unauthorizedCacheControlHeaderStrategy=$unauthorizedCacheControlHeaderStrategy")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheDataEncrypted.hashCode()
        result = 31 * result + (cacheTtlInSeconds)
        result = 31 * result + (cachingEnabled.hashCode())
        result = 31 * result + (dataTraceEnabled.hashCode())
        result = 31 * result + (loggingLevel?.hashCode() ?: 0)
        result = 31 * result + (metricsEnabled.hashCode())
        result = 31 * result + (requireAuthorizationForCacheControl.hashCode())
        result = 31 * result + (throttlingBurstLimit)
        result = 31 * result + (throttlingRateLimit.hashCode())
        result = 31 * result + (unauthorizedCacheControlHeaderStrategy?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as MethodSetting

        if (cacheDataEncrypted != other.cacheDataEncrypted) return false
        if (cacheTtlInSeconds != other.cacheTtlInSeconds) return false
        if (cachingEnabled != other.cachingEnabled) return false
        if (dataTraceEnabled != other.dataTraceEnabled) return false
        if (loggingLevel != other.loggingLevel) return false
        if (metricsEnabled != other.metricsEnabled) return false
        if (requireAuthorizationForCacheControl != other.requireAuthorizationForCacheControl) return false
        if (throttlingBurstLimit != other.throttlingBurstLimit) return false
        if (throttlingRateLimit != other.throttlingRateLimit) return false
        if (unauthorizedCacheControlHeaderStrategy != other.unauthorizedCacheControlHeaderStrategy) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.MethodSetting = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether the cached responses are encrypted.
         */
        public var cacheDataEncrypted: kotlin.Boolean = false
        /**
         * Specifies the time to live (TTL), in seconds, for cached responses. The higher the TTL, the longer the response will be cached.
         */
        public var cacheTtlInSeconds: kotlin.Int = 0
        /**
         * Specifies whether responses should be cached and returned for requests. A cache cluster must be enabled on the stage for responses to be cached.
         */
        public var cachingEnabled: kotlin.Boolean = false
        /**
         * Specifies whether data trace logging is enabled for this method, which affects the log entries pushed to Amazon CloudWatch Logs.
         */
        public var dataTraceEnabled: kotlin.Boolean = false
        /**
         * Specifies the logging level for this method, which affects the log entries pushed to Amazon CloudWatch Logs. Valid values are `OFF`, `ERROR`, and `INFO`. Choose `ERROR` to write only error-level entries to CloudWatch Logs, or choose `INFO` to include all `ERROR` events as well as extra informational events.
         */
        public var loggingLevel: kotlin.String? = null
        /**
         * Specifies whether Amazon CloudWatch metrics are enabled for this method.
         */
        public var metricsEnabled: kotlin.Boolean = false
        /**
         * Specifies whether authorization is required for a cache invalidation request.
         */
        public var requireAuthorizationForCacheControl: kotlin.Boolean = false
        /**
         * Specifies the throttling burst limit.
         */
        public var throttlingBurstLimit: kotlin.Int = 0
        /**
         * Specifies the throttling rate limit.
         */
        public var throttlingRateLimit: kotlin.Double = 0.0
        /**
         * Specifies how to handle unauthorized requests for cache invalidation.
         */
        public var unauthorizedCacheControlHeaderStrategy: aws.sdk.kotlin.services.apigateway.model.UnauthorizedCacheControlHeaderStrategy? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.MethodSetting) : this() {
            this.cacheDataEncrypted = x.cacheDataEncrypted
            this.cacheTtlInSeconds = x.cacheTtlInSeconds
            this.cachingEnabled = x.cachingEnabled
            this.dataTraceEnabled = x.dataTraceEnabled
            this.loggingLevel = x.loggingLevel
            this.metricsEnabled = x.metricsEnabled
            this.requireAuthorizationForCacheControl = x.requireAuthorizationForCacheControl
            this.throttlingBurstLimit = x.throttlingBurstLimit
            this.throttlingRateLimit = x.throttlingRateLimit
            this.unauthorizedCacheControlHeaderStrategy = x.unauthorizedCacheControlHeaderStrategy
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.MethodSetting = MethodSetting(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
