// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Requests API Gateway to create a Stage resource.
 */
public class CreateStageRequest private constructor(builder: Builder) {
    /**
     * Whether cache clustering is enabled for the stage.
     */
    public val cacheClusterEnabled: kotlin.Boolean? = builder.cacheClusterEnabled
    /**
     * The stage's cache capacity in GB. For more information about choosing a cache size, see [Enabling API caching to enhance responsiveness](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html).
     */
    public val cacheClusterSize: aws.sdk.kotlin.services.apigateway.model.CacheClusterSize? = builder.cacheClusterSize
    /**
     * The canary deployment settings of this stage.
     */
    public val canarySettings: aws.sdk.kotlin.services.apigateway.model.CanarySettings? = builder.canarySettings
    /**
     * The identifier of the Deployment resource for the Stage resource.
     */
    public val deploymentId: kotlin.String? = builder.deploymentId
    /**
     * The description of the Stage resource.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The version of the associated API documentation.
     */
    public val documentationVersion: kotlin.String? = builder.documentationVersion
    /**
     * The string identifier of the associated RestApi.
     */
    public val restApiId: kotlin.String? = builder.restApiId
    /**
     * The name for the Stage resource. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.
     */
    public val stageName: kotlin.String? = builder.stageName
    /**
     * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with `aws:`. The tag value can be up to 256 characters.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * Specifies whether active tracing with X-ray is enabled for the Stage.
     */
    public val tracingEnabled: kotlin.Boolean? = builder.tracingEnabled
    /**
     * A map that defines the stage variables for the new Stage resource. Variable names can have alphanumeric and underscore characters, and the values must match `[A-Za-z0-9-._~:/?#&=,]+`.
     */
    public val variables: Map<String, String>? = builder.variables

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.CreateStageRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateStageRequest(")
        append("cacheClusterEnabled=$cacheClusterEnabled,")
        append("cacheClusterSize=$cacheClusterSize,")
        append("canarySettings=$canarySettings,")
        append("deploymentId=$deploymentId,")
        append("description=$description,")
        append("documentationVersion=$documentationVersion,")
        append("restApiId=$restApiId,")
        append("stageName=$stageName,")
        append("tags=$tags,")
        append("tracingEnabled=$tracingEnabled,")
        append("variables=$variables")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheClusterEnabled?.hashCode() ?: 0
        result = 31 * result + (cacheClusterSize?.hashCode() ?: 0)
        result = 31 * result + (canarySettings?.hashCode() ?: 0)
        result = 31 * result + (deploymentId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (documentationVersion?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (stageName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (tracingEnabled?.hashCode() ?: 0)
        result = 31 * result + (variables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateStageRequest

        if (cacheClusterEnabled != other.cacheClusterEnabled) return false
        if (cacheClusterSize != other.cacheClusterSize) return false
        if (canarySettings != other.canarySettings) return false
        if (deploymentId != other.deploymentId) return false
        if (description != other.description) return false
        if (documentationVersion != other.documentationVersion) return false
        if (restApiId != other.restApiId) return false
        if (stageName != other.stageName) return false
        if (tags != other.tags) return false
        if (tracingEnabled != other.tracingEnabled) return false
        if (variables != other.variables) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.CreateStageRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Whether cache clustering is enabled for the stage.
         */
        public var cacheClusterEnabled: kotlin.Boolean? = null
        /**
         * The stage's cache capacity in GB. For more information about choosing a cache size, see [Enabling API caching to enhance responsiveness](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html).
         */
        public var cacheClusterSize: aws.sdk.kotlin.services.apigateway.model.CacheClusterSize? = null
        /**
         * The canary deployment settings of this stage.
         */
        public var canarySettings: aws.sdk.kotlin.services.apigateway.model.CanarySettings? = null
        /**
         * The identifier of the Deployment resource for the Stage resource.
         */
        public var deploymentId: kotlin.String? = null
        /**
         * The description of the Stage resource.
         */
        public var description: kotlin.String? = null
        /**
         * The version of the associated API documentation.
         */
        public var documentationVersion: kotlin.String? = null
        /**
         * The string identifier of the associated RestApi.
         */
        public var restApiId: kotlin.String? = null
        /**
         * The name for the Stage resource. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.
         */
        public var stageName: kotlin.String? = null
        /**
         * The key-value map of strings. The valid character set is &#91;a-zA-Z+-=._:/&#93;. The tag key can be up to 128 characters and must not start with `aws:`. The tag value can be up to 256 characters.
         */
        public var tags: Map<String, String>? = null
        /**
         * Specifies whether active tracing with X-ray is enabled for the Stage.
         */
        public var tracingEnabled: kotlin.Boolean? = null
        /**
         * A map that defines the stage variables for the new Stage resource. Variable names can have alphanumeric and underscore characters, and the values must match `[A-Za-z0-9-._~:/?#&=,]+`.
         */
        public var variables: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.CreateStageRequest) : this() {
            this.cacheClusterEnabled = x.cacheClusterEnabled
            this.cacheClusterSize = x.cacheClusterSize
            this.canarySettings = x.canarySettings
            this.deploymentId = x.deploymentId
            this.description = x.description
            this.documentationVersion = x.documentationVersion
            this.restApiId = x.restApiId
            this.stageName = x.stageName
            this.tags = x.tags
            this.tracingEnabled = x.tracingEnabled
            this.variables = x.variables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.CreateStageRequest = CreateStageRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.CanarySettings] inside the given [block]
         */
        public fun canarySettings(block: aws.sdk.kotlin.services.apigateway.model.CanarySettings.Builder.() -> kotlin.Unit) {
            this.canarySettings = aws.sdk.kotlin.services.apigateway.model.CanarySettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
