// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Requests API Gateway to create a Deployment resource.
 */
public class CreateDeploymentRequest private constructor(builder: Builder) {
    /**
     * Enables a cache cluster for the Stage resource specified in the input.
     */
    public val cacheClusterEnabled: kotlin.Boolean? = builder.cacheClusterEnabled
    /**
     * The stage's cache capacity in GB. For more information about choosing a cache size, see [Enabling API caching to enhance responsiveness](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html).
     */
    public val cacheClusterSize: aws.sdk.kotlin.services.apigateway.model.CacheClusterSize? = builder.cacheClusterSize
    /**
     * The input configuration for the canary deployment when the deployment is a canary release deployment.
     */
    public val canarySettings: aws.sdk.kotlin.services.apigateway.model.DeploymentCanarySettings? = builder.canarySettings
    /**
     * The description for the Deployment resource to create.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The string identifier of the associated RestApi.
     */
    public val restApiId: kotlin.String? = builder.restApiId
    /**
     * The description of the Stage resource for the Deployment resource to create.
     */
    public val stageDescription: kotlin.String? = builder.stageDescription
    /**
     * The name of the Stage resource for the Deployment resource to create.
     */
    public val stageName: kotlin.String? = builder.stageName
    /**
     * Specifies whether active tracing with X-ray is enabled for the Stage.
     */
    public val tracingEnabled: kotlin.Boolean? = builder.tracingEnabled
    /**
     * A map that defines the stage variables for the Stage resource that is associated with the new deployment. Variable names can have alphanumeric and underscore characters, and the values must match `[A-Za-z0-9-._~:/?#&=,]+`.
     */
    public val variables: Map<String, String>? = builder.variables

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.CreateDeploymentRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateDeploymentRequest(")
        append("cacheClusterEnabled=$cacheClusterEnabled,")
        append("cacheClusterSize=$cacheClusterSize,")
        append("canarySettings=$canarySettings,")
        append("description=$description,")
        append("restApiId=$restApiId,")
        append("stageDescription=$stageDescription,")
        append("stageName=$stageName,")
        append("tracingEnabled=$tracingEnabled,")
        append("variables=$variables")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cacheClusterEnabled?.hashCode() ?: 0
        result = 31 * result + (cacheClusterSize?.hashCode() ?: 0)
        result = 31 * result + (canarySettings?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (restApiId?.hashCode() ?: 0)
        result = 31 * result + (stageDescription?.hashCode() ?: 0)
        result = 31 * result + (stageName?.hashCode() ?: 0)
        result = 31 * result + (tracingEnabled?.hashCode() ?: 0)
        result = 31 * result + (variables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateDeploymentRequest

        if (cacheClusterEnabled != other.cacheClusterEnabled) return false
        if (cacheClusterSize != other.cacheClusterSize) return false
        if (canarySettings != other.canarySettings) return false
        if (description != other.description) return false
        if (restApiId != other.restApiId) return false
        if (stageDescription != other.stageDescription) return false
        if (stageName != other.stageName) return false
        if (tracingEnabled != other.tracingEnabled) return false
        if (variables != other.variables) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.CreateDeploymentRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Enables a cache cluster for the Stage resource specified in the input.
         */
        public var cacheClusterEnabled: kotlin.Boolean? = null
        /**
         * The stage's cache capacity in GB. For more information about choosing a cache size, see [Enabling API caching to enhance responsiveness](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html).
         */
        public var cacheClusterSize: aws.sdk.kotlin.services.apigateway.model.CacheClusterSize? = null
        /**
         * The input configuration for the canary deployment when the deployment is a canary release deployment.
         */
        public var canarySettings: aws.sdk.kotlin.services.apigateway.model.DeploymentCanarySettings? = null
        /**
         * The description for the Deployment resource to create.
         */
        public var description: kotlin.String? = null
        /**
         * The string identifier of the associated RestApi.
         */
        public var restApiId: kotlin.String? = null
        /**
         * The description of the Stage resource for the Deployment resource to create.
         */
        public var stageDescription: kotlin.String? = null
        /**
         * The name of the Stage resource for the Deployment resource to create.
         */
        public var stageName: kotlin.String? = null
        /**
         * Specifies whether active tracing with X-ray is enabled for the Stage.
         */
        public var tracingEnabled: kotlin.Boolean? = null
        /**
         * A map that defines the stage variables for the Stage resource that is associated with the new deployment. Variable names can have alphanumeric and underscore characters, and the values must match `[A-Za-z0-9-._~:/?#&=,]+`.
         */
        public var variables: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.CreateDeploymentRequest) : this() {
            this.cacheClusterEnabled = x.cacheClusterEnabled
            this.cacheClusterSize = x.cacheClusterSize
            this.canarySettings = x.canarySettings
            this.description = x.description
            this.restApiId = x.restApiId
            this.stageDescription = x.stageDescription
            this.stageName = x.stageName
            this.tracingEnabled = x.tracingEnabled
            this.variables = x.variables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.CreateDeploymentRequest = CreateDeploymentRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.apigateway.model.DeploymentCanarySettings] inside the given [block]
         */
        public fun canarySettings(block: aws.sdk.kotlin.services.apigateway.model.DeploymentCanarySettings.Builder.() -> kotlin.Unit) {
            this.canarySettings = aws.sdk.kotlin.services.apigateway.model.DeploymentCanarySettings.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
