// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.services.apigateway.model.PutMethodResponseRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutMethodResponseOperationSerializer: HttpSerialize<PutMethodResponseRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutMethodResponseRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "restapis",
                "${input.restApiId}".encodeLabel(),
                "resources",
                "${input.resourceId}".encodeLabel(),
                "methods",
                "${input.httpMethod}".encodeLabel(),
                "responses",
                "${input.statusCode}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializePutMethodResponseOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializePutMethodResponseOperationBody(context: ExecutionContext, input: PutMethodResponseRequest): ByteArray {
    val serializer = JsonSerializer()
    val RESPONSEMODELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseModels"))
    val RESPONSEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseParameters"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESPONSEMODELS_DESCRIPTOR)
        field(RESPONSEPARAMETERS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.responseModels != null) {
            mapField(RESPONSEMODELS_DESCRIPTOR) {
                input.responseModels.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.responseParameters != null) {
            mapField(RESPONSEPARAMETERS_DESCRIPTOR) {
                input.responseParameters.forEach { (key, value) -> entry(key, value) }
            }
        }
    }
    return serializer.toByteArray()
}
