// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.services.apigateway.model.PutMethodRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutMethodOperationSerializer: HttpSerialize<PutMethodRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutMethodRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "restapis",
                "${input.restApiId}".encodeLabel(),
                "resources",
                "${input.resourceId}".encodeLabel(),
                "methods",
                "${input.httpMethod}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializePutMethodOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializePutMethodOperationBody(context: ExecutionContext, input: PutMethodRequest): ByteArray {
    val serializer = JsonSerializer()
    val APIKEYREQUIRED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("apiKeyRequired"))
    val AUTHORIZATIONSCOPES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("authorizationScopes"))
    val AUTHORIZATIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizationType"))
    val AUTHORIZERID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("authorizerId"))
    val OPERATIONNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("operationName"))
    val REQUESTMODELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestModels"))
    val REQUESTPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestParameters"))
    val REQUESTVALIDATORID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("requestValidatorId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APIKEYREQUIRED_DESCRIPTOR)
        field(AUTHORIZATIONSCOPES_DESCRIPTOR)
        field(AUTHORIZATIONTYPE_DESCRIPTOR)
        field(AUTHORIZERID_DESCRIPTOR)
        field(OPERATIONNAME_DESCRIPTOR)
        field(REQUESTMODELS_DESCRIPTOR)
        field(REQUESTPARAMETERS_DESCRIPTOR)
        field(REQUESTVALIDATORID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.apiKeyRequired != false) field(APIKEYREQUIRED_DESCRIPTOR, input.apiKeyRequired)
        if (input.authorizationScopes != null) {
            listField(AUTHORIZATIONSCOPES_DESCRIPTOR) {
                for (el0 in input.authorizationScopes) {
                    serializeString(el0)
                }
            }
        }
        input.authorizationType?.let { field(AUTHORIZATIONTYPE_DESCRIPTOR, it) }
        input.authorizerId?.let { field(AUTHORIZERID_DESCRIPTOR, it) }
        input.operationName?.let { field(OPERATIONNAME_DESCRIPTOR, it) }
        if (input.requestModels != null) {
            mapField(REQUESTMODELS_DESCRIPTOR) {
                input.requestModels.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.requestParameters != null) {
            mapField(REQUESTPARAMETERS_DESCRIPTOR) {
                input.requestParameters.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.requestValidatorId?.let { field(REQUESTVALIDATORID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
