// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.services.apigateway.model.ConnectionType
import aws.sdk.kotlin.services.apigateway.model.ContentHandlingStrategy
import aws.sdk.kotlin.services.apigateway.model.IntegrationType
import aws.sdk.kotlin.services.apigateway.model.PutIntegrationRequest
import aws.sdk.kotlin.services.apigateway.model.TlsConfig
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutIntegrationOperationSerializer: HttpSerialize<PutIntegrationRequest> {
    override suspend fun serialize(context: ExecutionContext, input: PutIntegrationRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.PUT

        builder.url {
            val pathSegments = listOf<String>(
                "restapis",
                "${input.restApiId}".encodeLabel(),
                "resources",
                "${input.resourceId}".encodeLabel(),
                "methods",
                "${input.httpMethod}".encodeLabel(),
                "integration",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializePutIntegrationOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializePutIntegrationOperationBody(context: ExecutionContext, input: PutIntegrationRequest): ByteArray {
    val serializer = JsonSerializer()
    val CACHEKEYPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("cacheKeyParameters"))
    val CACHENAMESPACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("cacheNamespace"))
    val CONNECTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("connectionId"))
    val CONNECTIONTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("connectionType"))
    val CONTENTHANDLING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("contentHandling"))
    val CREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("credentials"))
    val INTEGRATIONHTTPMETHOD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("httpMethod"))
    val PASSTHROUGHBEHAVIOR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("passthroughBehavior"))
    val REQUESTPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestParameters"))
    val REQUESTTEMPLATES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("requestTemplates"))
    val TIMEOUTINMILLIS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Integer, JsonSerialName("timeoutInMillis"))
    val TLSCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tlsConfig"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("type"))
    val URI_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("uri"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CACHEKEYPARAMETERS_DESCRIPTOR)
        field(CACHENAMESPACE_DESCRIPTOR)
        field(CONNECTIONID_DESCRIPTOR)
        field(CONNECTIONTYPE_DESCRIPTOR)
        field(CONTENTHANDLING_DESCRIPTOR)
        field(CREDENTIALS_DESCRIPTOR)
        field(INTEGRATIONHTTPMETHOD_DESCRIPTOR)
        field(PASSTHROUGHBEHAVIOR_DESCRIPTOR)
        field(REQUESTPARAMETERS_DESCRIPTOR)
        field(REQUESTTEMPLATES_DESCRIPTOR)
        field(TIMEOUTINMILLIS_DESCRIPTOR)
        field(TLSCONFIG_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
        field(URI_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.cacheKeyParameters != null) {
            listField(CACHEKEYPARAMETERS_DESCRIPTOR) {
                for (el0 in input.cacheKeyParameters) {
                    serializeString(el0)
                }
            }
        }
        input.cacheNamespace?.let { field(CACHENAMESPACE_DESCRIPTOR, it) }
        input.connectionId?.let { field(CONNECTIONID_DESCRIPTOR, it) }
        input.connectionType?.let { field(CONNECTIONTYPE_DESCRIPTOR, it.value) }
        input.contentHandling?.let { field(CONTENTHANDLING_DESCRIPTOR, it.value) }
        input.credentials?.let { field(CREDENTIALS_DESCRIPTOR, it) }
        input.integrationHttpMethod?.let { field(INTEGRATIONHTTPMETHOD_DESCRIPTOR, it) }
        input.passthroughBehavior?.let { field(PASSTHROUGHBEHAVIOR_DESCRIPTOR, it) }
        if (input.requestParameters != null) {
            mapField(REQUESTPARAMETERS_DESCRIPTOR) {
                input.requestParameters.forEach { (key, value) -> entry(key, value) }
            }
        }
        if (input.requestTemplates != null) {
            mapField(REQUESTTEMPLATES_DESCRIPTOR) {
                input.requestTemplates.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.timeoutInMillis?.let { field(TIMEOUTINMILLIS_DESCRIPTOR, it) }
        input.tlsConfig?.let { field(TLSCONFIG_DESCRIPTOR, it, ::serializeTlsConfigDocument) }
        input.type?.let { field(TYPE_DESCRIPTOR, it.value) }
        input.uri?.let { field(URI_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
