// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.GetMethodResponseResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableMapOf


internal class GetMethodResponseOperationDeserializer: HttpDeserialize<GetMethodResponseResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetMethodResponseResponse {
        if (!response.status.isSuccess()) {
            throwGetMethodResponseError(context, response)
        }
        val builder = GetMethodResponseResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetMethodResponseOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetMethodResponseError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ApiGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetMethodResponseOperationBody(builder: GetMethodResponseResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val RESPONSEMODELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseModels"))
    val RESPONSEPARAMETERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("responseParameters"))
    val STATUSCODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("statusCode"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(RESPONSEMODELS_DESCRIPTOR)
        field(RESPONSEPARAMETERS_DESCRIPTOR)
        field(STATUSCODE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                RESPONSEMODELS_DESCRIPTOR.index -> builder.responseModels =
                    deserializer.deserializeMap(RESPONSEMODELS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                RESPONSEPARAMETERS_DESCRIPTOR.index -> builder.responseParameters =
                    deserializer.deserializeMap(RESPONSEPARAMETERS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, Boolean>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeBoolean() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                STATUSCODE_DESCRIPTOR.index -> builder.statusCode = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
