// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.transform

import aws.sdk.kotlin.services.apigateway.model.ApiGatewayException
import aws.sdk.kotlin.services.apigateway.model.GetBasePathMappingResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetBasePathMappingOperationDeserializer: HttpDeserialize<GetBasePathMappingResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetBasePathMappingResponse {
        if (!response.status.isSuccess()) {
            throwGetBasePathMappingError(context, response)
        }
        val builder = GetBasePathMappingResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetBasePathMappingOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetBasePathMappingError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw ApiGatewayException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> ApiGatewayException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBasePathMappingOperationBody(builder: GetBasePathMappingResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BASEPATH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("basePath"))
    val RESTAPIID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("restApiId"))
    val STAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stage"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BASEPATH_DESCRIPTOR)
        field(RESTAPIID_DESCRIPTOR)
        field(STAGE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BASEPATH_DESCRIPTOR.index -> builder.basePath = deserializeString()
                RESTAPIID_DESCRIPTOR.index -> builder.restApiId = deserializeString()
                STAGE_DESCRIPTOR.index -> builder.stage = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
