// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * A request to change information about an ApiKey resource.
 */
public class UpdateApiKeyRequest private constructor(builder: Builder) {
    /**
     * The identifier of the ApiKey resource to be updated.
     */
    public val apiKey: kotlin.String? = requireNotNull(builder.apiKey) { "A non-null value must be provided for apiKey" }
    /**
     * For more information about supported patch operations, see [Patch Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
     */
    public val patchOperations: List<PatchOperation>? = builder.patchOperations

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.UpdateApiKeyRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateApiKeyRequest(")
        append("apiKey=$apiKey,")
        append("patchOperations=$patchOperations")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = apiKey?.hashCode() ?: 0
        result = 31 * result + (patchOperations?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateApiKeyRequest

        if (apiKey != other.apiKey) return false
        if (patchOperations != other.patchOperations) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.UpdateApiKeyRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The identifier of the ApiKey resource to be updated.
         */
        public var apiKey: kotlin.String? = null
        /**
         * For more information about supported patch operations, see [Patch Operations](https://docs.aws.amazon.com/apigateway/latest/api/patch-operations.html).
         */
        public var patchOperations: List<PatchOperation>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.UpdateApiKeyRequest) : this() {
            this.apiKey = x.apiKey
            this.patchOperations = x.patchOperations
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.UpdateApiKeyRequest = UpdateApiKeyRequest(this)
    }
}
