// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model



/**
 * Represents the response of the test invoke request for a custom Authorizer
 */
public class TestInvokeAuthorizerResponse private constructor(builder: Builder) {
    /**
     * The authorization response.
     */
    public val authorization: Map<String, List<String>>? = builder.authorization
    /**
     * The open identity claims, with any supported custom attributes, returned from the Cognito Your User Pool configured for the API.
     */
    public val claims: Map<String, String>? = builder.claims
    /**
     * The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.
     */
    public val clientStatus: kotlin.Int = builder.clientStatus
    /**
     * The execution latency of the test authorizer request.
     */
    public val latency: kotlin.Long = builder.latency
    /**
     * The API Gateway execution log for the test authorizer request.
     */
    public val log: kotlin.String? = builder.log
    /**
     * The JSON policy document returned by the Authorizer
     */
    public val policy: kotlin.String? = builder.policy
    /**
     * The principal identity returned by the Authorizer
     */
    public val principalId: kotlin.String? = builder.principalId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.TestInvokeAuthorizerResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("TestInvokeAuthorizerResponse(")
        append("authorization=$authorization,")
        append("claims=$claims,")
        append("clientStatus=$clientStatus,")
        append("latency=$latency,")
        append("log=$log,")
        append("policy=$policy,")
        append("principalId=$principalId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authorization?.hashCode() ?: 0
        result = 31 * result + (claims?.hashCode() ?: 0)
        result = 31 * result + (clientStatus)
        result = 31 * result + (latency.hashCode())
        result = 31 * result + (log?.hashCode() ?: 0)
        result = 31 * result + (policy?.hashCode() ?: 0)
        result = 31 * result + (principalId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as TestInvokeAuthorizerResponse

        if (authorization != other.authorization) return false
        if (claims != other.claims) return false
        if (clientStatus != other.clientStatus) return false
        if (latency != other.latency) return false
        if (log != other.log) return false
        if (policy != other.policy) return false
        if (principalId != other.principalId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.TestInvokeAuthorizerResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The authorization response.
         */
        public var authorization: Map<String, List<String>>? = null
        /**
         * The open identity claims, with any supported custom attributes, returned from the Cognito Your User Pool configured for the API.
         */
        public var claims: Map<String, String>? = null
        /**
         * The HTTP status code that the client would have received. Value is 0 if the authorizer succeeded.
         */
        public var clientStatus: kotlin.Int = 0
        /**
         * The execution latency of the test authorizer request.
         */
        public var latency: kotlin.Long = 0L
        /**
         * The API Gateway execution log for the test authorizer request.
         */
        public var log: kotlin.String? = null
        /**
         * The JSON policy document returned by the Authorizer
         */
        public var policy: kotlin.String? = null
        /**
         * The principal identity returned by the Authorizer
         */
        public var principalId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.TestInvokeAuthorizerResponse) : this() {
            this.authorization = x.authorization
            this.claims = x.claims
            this.clientStatus = x.clientStatus
            this.latency = x.latency
            this.log = x.log
            this.policy = x.policy
            this.principalId = x.principalId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.TestInvokeAuthorizerResponse = TestInvokeAuthorizerResponse(this)
    }
}
