// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.apigateway.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A resource that can be distributed to callers for executing Method resources that require an API key. API keys can be mapped to any Stage on any RestApi, which indicates that the callers with the API key can make requests to that stage.
 */
public class GetApiKeyResponse private constructor(builder: Builder) {
    /**
     * The timestamp when the API Key was created.
     */
    public val createdDate: aws.smithy.kotlin.runtime.time.Instant? = builder.createdDate
    /**
     * An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
     */
    public val customerId: kotlin.String? = builder.customerId
    /**
     * The description of the API Key.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Specifies whether the API Key can be used by callers.
     */
    public val enabled: kotlin.Boolean = builder.enabled
    /**
     * The identifier of the API Key.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The timestamp when the API Key was last updated.
     */
    public val lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUpdatedDate
    /**
     * The name of the API Key.
     */
    public val name: kotlin.String? = builder.name
    /**
     * A list of Stage resources that are associated with the ApiKey resource.
     */
    public val stageKeys: List<String>? = builder.stageKeys
    /**
     * The collection of tags. Each tag element is associated with a given resource.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The value of the API Key.
     */
    public val value: kotlin.String? = builder.value

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.apigateway.model.GetApiKeyResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetApiKeyResponse(")
        append("createdDate=$createdDate,")
        append("customerId=$customerId,")
        append("description=$description,")
        append("enabled=$enabled,")
        append("id=$id,")
        append("lastUpdatedDate=$lastUpdatedDate,")
        append("name=$name,")
        append("stageKeys=$stageKeys,")
        append("tags=$tags,")
        append("value=$value")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdDate?.hashCode() ?: 0
        result = 31 * result + (customerId?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (enabled.hashCode())
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (lastUpdatedDate?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (stageKeys?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (value?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetApiKeyResponse

        if (createdDate != other.createdDate) return false
        if (customerId != other.customerId) return false
        if (description != other.description) return false
        if (enabled != other.enabled) return false
        if (id != other.id) return false
        if (lastUpdatedDate != other.lastUpdatedDate) return false
        if (name != other.name) return false
        if (stageKeys != other.stageKeys) return false
        if (tags != other.tags) return false
        if (value != other.value) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.apigateway.model.GetApiKeyResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The timestamp when the API Key was created.
         */
        public var createdDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace.
         */
        public var customerId: kotlin.String? = null
        /**
         * The description of the API Key.
         */
        public var description: kotlin.String? = null
        /**
         * Specifies whether the API Key can be used by callers.
         */
        public var enabled: kotlin.Boolean = false
        /**
         * The identifier of the API Key.
         */
        public var id: kotlin.String? = null
        /**
         * The timestamp when the API Key was last updated.
         */
        public var lastUpdatedDate: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the API Key.
         */
        public var name: kotlin.String? = null
        /**
         * A list of Stage resources that are associated with the ApiKey resource.
         */
        public var stageKeys: List<String>? = null
        /**
         * The collection of tags. Each tag element is associated with a given resource.
         */
        public var tags: Map<String, String>? = null
        /**
         * The value of the API Key.
         */
        public var value: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.apigateway.model.GetApiKeyResponse) : this() {
            this.createdDate = x.createdDate
            this.customerId = x.customerId
            this.description = x.description
            this.enabled = x.enabled
            this.id = x.id
            this.lastUpdatedDate = x.lastUpdatedDate
            this.name = x.name
            this.stageKeys = x.stageKeys
            this.tags = x.tags
            this.value = x.value
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.apigateway.model.GetApiKeyResponse = GetApiKeyResponse(this)
    }
}
