// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifybackend.transform

import aws.sdk.kotlin.services.amplifybackend.model.AmplifyBackendException
import aws.sdk.kotlin.services.amplifybackend.model.LoginAuthConfigReqObj
import aws.sdk.kotlin.services.amplifybackend.model.UpdateBackendConfigResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateBackendConfigOperationDeserializer: HttpDeserialize<UpdateBackendConfigResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateBackendConfigResponse {
        if (!response.status.isSuccess()) {
            throwUpdateBackendConfigError(context, response)
        }
        val builder = UpdateBackendConfigResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateBackendConfigOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateBackendConfigError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AmplifyBackendException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "GatewayTimeoutException" -> GatewayTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AmplifyBackendException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateBackendConfigOperationBody(builder: UpdateBackendConfigResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("appId"))
    val BACKENDMANAGERAPPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("backendManagerAppId"))
    val ERROR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("error"))
    val LOGINAUTHCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("loginAuthConfig"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPID_DESCRIPTOR)
        field(BACKENDMANAGERAPPID_DESCRIPTOR)
        field(ERROR_DESCRIPTOR)
        field(LOGINAUTHCONFIG_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPID_DESCRIPTOR.index -> builder.appId = deserializeString()
                BACKENDMANAGERAPPID_DESCRIPTOR.index -> builder.backendManagerAppId = deserializeString()
                ERROR_DESCRIPTOR.index -> builder.error = deserializeString()
                LOGINAUTHCONFIG_DESCRIPTOR.index -> builder.loginAuthConfig = deserializeLoginAuthConfigReqObjDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
