// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplifybackend.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.amplifybackend.model.AmplifyBackendException
import aws.sdk.kotlin.services.amplifybackend.model.DeleteBackendStorageResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteBackendStorageOperationDeserializer: HttpDeserialize<DeleteBackendStorageResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteBackendStorageResponse {
        if (!response.status.isSuccess()) {
            throwDeleteBackendStorageError(context, response)
        }
        val builder = DeleteBackendStorageResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteBackendStorageOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteBackendStorageError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw AmplifyBackendException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedResponse)
        "GatewayTimeoutException" -> GatewayTimeoutExceptionDeserializer().deserialize(context, wrappedResponse)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> AmplifyBackendException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteBackendStorageOperationBody(builder: DeleteBackendStorageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("appId"))
    val BACKENDENVIRONMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("backendEnvironmentName"))
    val JOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobId"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPID_DESCRIPTOR)
        field(BACKENDENVIRONMENTNAME_DESCRIPTOR)
        field(JOBID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPID_DESCRIPTOR.index -> builder.appId = deserializeString()
                BACKENDENVIRONMENTNAME_DESCRIPTOR.index -> builder.backendEnvironmentName = deserializeString()
                JOBID_DESCRIPTOR.index -> builder.jobId = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
