// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.serde

import aws.sdk.kotlin.services.amplify.model.AmplifyException
import aws.sdk.kotlin.services.amplify.model.GetArtifactUrlResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetArtifactUrlOperationDeserializer: HttpDeserialize<GetArtifactUrlResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): GetArtifactUrlResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetArtifactUrlError(context, call)
        }
        val builder = GetArtifactUrlResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetArtifactUrlOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwGetArtifactUrlError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AmplifyException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AmplifyException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetArtifactUrlOperationBody(builder: GetArtifactUrlResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARTIFACTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("artifactId"))
    val ARTIFACTURL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("artifactUrl"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARTIFACTID_DESCRIPTOR)
        field(ARTIFACTURL_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARTIFACTID_DESCRIPTOR.index -> builder.artifactId = deserializeString()
                ARTIFACTURL_DESCRIPTOR.index -> builder.artifactUrl = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
