// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.serde

import aws.sdk.kotlin.services.amplify.model.AmplifyException
import aws.sdk.kotlin.services.amplify.model.App
import aws.sdk.kotlin.services.amplify.model.CreateAppResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateAppOperationDeserializer: HttpDeserialize<CreateAppResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): CreateAppResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwCreateAppError(context, call)
        }
        val builder = CreateAppResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateAppOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwCreateAppError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw AmplifyException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "DependentServiceFailureException" -> DependentServiceFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalFailureException" -> InternalFailureExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> AmplifyException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeCreateAppOperationBody(builder: CreateAppResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("app"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APP_DESCRIPTOR.index -> builder.app = deserializeAppDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
