// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes an execution step, for an execution job, for an Amplify app.
 */
public class Step private constructor(builder: Builder) {
    /**
     * The URL to the artifact for the execution step.
     */
    public val artifactsUrl: kotlin.String? = builder.artifactsUrl
    /**
     * The context for the current step. Includes a build image if the step is build.
     */
    public val context: kotlin.String? = builder.context
    /**
     * The end date and time of the execution step.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The URL to the logs for the execution step.
     */
    public val logUrl: kotlin.String? = builder.logUrl
    /**
     * The list of screenshot URLs for the execution step, if relevant.
     */
    public val screenshots: Map<String, String>? = builder.screenshots
    /**
     * The start date and time of the execution step.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The status of the execution step.
     */
    public val status: aws.sdk.kotlin.services.amplify.model.JobStatus? = builder.status
    /**
     * The reason for the current step status.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The name of the execution step.
     */
    public val stepName: kotlin.String? = builder.stepName
    /**
     * The URL to the test artifact for the execution step.
     */
    public val testArtifactsUrl: kotlin.String? = builder.testArtifactsUrl
    /**
     * The URL to the test configuration for the execution step.
     */
    public val testConfigUrl: kotlin.String? = builder.testConfigUrl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.Step = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Step(")
        append("artifactsUrl=$artifactsUrl,")
        append("context=$context,")
        append("endTime=$endTime,")
        append("logUrl=$logUrl,")
        append("screenshots=$screenshots,")
        append("startTime=$startTime,")
        append("status=$status,")
        append("statusReason=$statusReason,")
        append("stepName=$stepName,")
        append("testArtifactsUrl=$testArtifactsUrl,")
        append("testConfigUrl=$testConfigUrl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = artifactsUrl?.hashCode() ?: 0
        result = 31 * result + (context?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (logUrl?.hashCode() ?: 0)
        result = 31 * result + (screenshots?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (stepName?.hashCode() ?: 0)
        result = 31 * result + (testArtifactsUrl?.hashCode() ?: 0)
        result = 31 * result + (testConfigUrl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Step

        if (artifactsUrl != other.artifactsUrl) return false
        if (context != other.context) return false
        if (endTime != other.endTime) return false
        if (logUrl != other.logUrl) return false
        if (screenshots != other.screenshots) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false
        if (statusReason != other.statusReason) return false
        if (stepName != other.stepName) return false
        if (testArtifactsUrl != other.testArtifactsUrl) return false
        if (testConfigUrl != other.testConfigUrl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.Step = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The URL to the artifact for the execution step.
         */
        public var artifactsUrl: kotlin.String? = null
        /**
         * The context for the current step. Includes a build image if the step is build.
         */
        public var context: kotlin.String? = null
        /**
         * The end date and time of the execution step.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The URL to the logs for the execution step.
         */
        public var logUrl: kotlin.String? = null
        /**
         * The list of screenshot URLs for the execution step, if relevant.
         */
        public var screenshots: Map<String, String>? = null
        /**
         * The start date and time of the execution step.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The status of the execution step.
         */
        public var status: aws.sdk.kotlin.services.amplify.model.JobStatus? = null
        /**
         * The reason for the current step status.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The name of the execution step.
         */
        public var stepName: kotlin.String? = null
        /**
         * The URL to the test artifact for the execution step.
         */
        public var testArtifactsUrl: kotlin.String? = null
        /**
         * The URL to the test configuration for the execution step.
         */
        public var testConfigUrl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.Step) : this() {
            this.artifactsUrl = x.artifactsUrl
            this.context = x.context
            this.endTime = x.endTime
            this.logUrl = x.logUrl
            this.screenshots = x.screenshots
            this.startTime = x.startTime
            this.status = x.status
            this.statusReason = x.statusReason
            this.stepName = x.stepName
            this.testArtifactsUrl = x.testArtifactsUrl
            this.testConfigUrl = x.testConfigUrl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.Step = Step(this)

        internal fun correctErrors(): Builder {
            if (endTime == null) endTime = Instant.fromEpochSeconds(0)
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            if (status == null) status = JobStatus.SdkUnknown("no value provided")
            if (stepName == null) stepName = ""
            return this
        }
    }
}
