// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * The request structure for the start job request.
 */
public class StartJobRequest private constructor(builder: Builder) {
    /**
     * The unique ID for an Amplify app.
     */
    public val appId: kotlin.String? = requireNotNull(builder.appId) { "A non-null value must be provided for appId" }
    /**
     * The branch name for the job.
     */
    public val branchName: kotlin.String? = requireNotNull(builder.branchName) { "A non-null value must be provided for branchName" }
    /**
     * The commit ID from a third-party repository provider for the job.
     */
    public val commitId: kotlin.String? = builder.commitId
    /**
     * The commit message from a third-party repository provider for the job.
     */
    public val commitMessage: kotlin.String? = builder.commitMessage
    /**
     * The commit date and time for the job.
     */
    public val commitTime: aws.smithy.kotlin.runtime.time.Instant? = builder.commitTime
    /**
     * The unique ID for an existing job. This is required if the value of `jobType` is `RETRY`.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * A descriptive reason for starting this job.
     */
    public val jobReason: kotlin.String? = builder.jobReason
    /**
     * Describes the type for the job. The job type `RELEASE` starts a new job with the latest change from the specified branch. This value is available only for apps that are connected to a repository. The job type `RETRY` retries an existing job. If the job type value is `RETRY`, the `jobId` is also required.
     */
    public val jobType: aws.sdk.kotlin.services.amplify.model.JobType? = builder.jobType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.StartJobRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartJobRequest(")
        append("appId=$appId,")
        append("branchName=$branchName,")
        append("commitId=$commitId,")
        append("commitMessage=$commitMessage,")
        append("commitTime=$commitTime,")
        append("jobId=$jobId,")
        append("jobReason=$jobReason,")
        append("jobType=$jobType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appId?.hashCode() ?: 0
        result = 31 * result + (branchName?.hashCode() ?: 0)
        result = 31 * result + (commitId?.hashCode() ?: 0)
        result = 31 * result + (commitMessage?.hashCode() ?: 0)
        result = 31 * result + (commitTime?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobReason?.hashCode() ?: 0)
        result = 31 * result + (jobType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartJobRequest

        if (appId != other.appId) return false
        if (branchName != other.branchName) return false
        if (commitId != other.commitId) return false
        if (commitMessage != other.commitMessage) return false
        if (commitTime != other.commitTime) return false
        if (jobId != other.jobId) return false
        if (jobReason != other.jobReason) return false
        if (jobType != other.jobType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.StartJobRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique ID for an Amplify app.
         */
        public var appId: kotlin.String? = null
        /**
         * The branch name for the job.
         */
        public var branchName: kotlin.String? = null
        /**
         * The commit ID from a third-party repository provider for the job.
         */
        public var commitId: kotlin.String? = null
        /**
         * The commit message from a third-party repository provider for the job.
         */
        public var commitMessage: kotlin.String? = null
        /**
         * The commit date and time for the job.
         */
        public var commitTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique ID for an existing job. This is required if the value of `jobType` is `RETRY`.
         */
        public var jobId: kotlin.String? = null
        /**
         * A descriptive reason for starting this job.
         */
        public var jobReason: kotlin.String? = null
        /**
         * Describes the type for the job. The job type `RELEASE` starts a new job with the latest change from the specified branch. This value is available only for apps that are connected to a repository. The job type `RETRY` retries an existing job. If the job type value is `RETRY`, the `jobId` is also required.
         */
        public var jobType: aws.sdk.kotlin.services.amplify.model.JobType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.StartJobRequest) : this() {
            this.appId = x.appId
            this.branchName = x.branchName
            this.commitId = x.commitId
            this.commitMessage = x.commitMessage
            this.commitTime = x.commitTime
            this.jobId = x.jobId
            this.jobReason = x.jobReason
            this.jobType = x.jobType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.StartJobRequest = StartJobRequest(this)

        internal fun correctErrors(): Builder {
            if (appId == null) appId = ""
            if (branchName == null) branchName = ""
            if (jobType == null) jobType = JobType.SdkUnknown("no value provided")
            return this
        }
    }
}
