// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.transform

import aws.sdk.kotlin.services.amplify.model.JobType
import aws.sdk.kotlin.services.amplify.model.StartJobRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class StartJobOperationSerializer: HttpSerialize<StartJobRequest> {
    override suspend fun serialize(context: ExecutionContext, input: StartJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "apps",
                "${input.appId}".encodeLabel(),
                "branches",
                "${input.branchName}".encodeLabel(),
                "jobs",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeStartJobOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartJobOperationBody(context: ExecutionContext, input: StartJobRequest): ByteArray {
    val serializer = JsonSerializer()
    val COMMITID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("commitId"))
    val COMMITMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("commitMessage"))
    val COMMITTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("commitTime"))
    val JOBID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobId"))
    val JOBREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("jobReason"))
    val JOBTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("jobType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(COMMITID_DESCRIPTOR)
        field(COMMITMESSAGE_DESCRIPTOR)
        field(COMMITTIME_DESCRIPTOR)
        field(JOBID_DESCRIPTOR)
        field(JOBREASON_DESCRIPTOR)
        field(JOBTYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.commitId?.let { field(COMMITID_DESCRIPTOR, it) }
        input.commitMessage?.let { field(COMMITMESSAGE_DESCRIPTOR, it) }
        input.commitTime?.let { field(COMMITTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.jobId?.let { field(JOBID_DESCRIPTOR, it) }
        input.jobReason?.let { field(JOBREASON_DESCRIPTOR, it) }
        input.jobType?.let { field(JOBTYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
