// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model



/**
 * The request structure for the update domain association request.
 */
public class UpdateDomainAssociationRequest private constructor(builder: Builder) {
    /**
     * The unique ID for an Amplify app.
     */
    public val appId: kotlin.String? = requireNotNull(builder.appId) { "A non-null value must be provided for appId" }
    /**
     * Sets the branch patterns for automatic subdomain creation.
     */
    public val autoSubDomainCreationPatterns: List<String>? = builder.autoSubDomainCreationPatterns
    /**
     * The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains.
     */
    public val autoSubDomainIamRole: kotlin.String? = builder.autoSubDomainIamRole
    /**
     * The name of the domain.
     */
    public val domainName: kotlin.String? = requireNotNull(builder.domainName) { "A non-null value must be provided for domainName" }
    /**
     * Enables the automated creation of subdomains for branches.
     */
    public val enableAutoSubDomain: kotlin.Boolean? = builder.enableAutoSubDomain
    /**
     * Describes the settings for the subdomain.
     */
    public val subDomainSettings: List<SubDomainSetting>? = builder.subDomainSettings

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.UpdateDomainAssociationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateDomainAssociationRequest(")
        append("appId=$appId,")
        append("autoSubDomainCreationPatterns=$autoSubDomainCreationPatterns,")
        append("autoSubDomainIamRole=$autoSubDomainIamRole,")
        append("domainName=$domainName,")
        append("enableAutoSubDomain=$enableAutoSubDomain,")
        append("subDomainSettings=$subDomainSettings")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appId?.hashCode() ?: 0
        result = 31 * result + (autoSubDomainCreationPatterns?.hashCode() ?: 0)
        result = 31 * result + (autoSubDomainIamRole?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (enableAutoSubDomain?.hashCode() ?: 0)
        result = 31 * result + (subDomainSettings?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateDomainAssociationRequest

        if (appId != other.appId) return false
        if (autoSubDomainCreationPatterns != other.autoSubDomainCreationPatterns) return false
        if (autoSubDomainIamRole != other.autoSubDomainIamRole) return false
        if (domainName != other.domainName) return false
        if (enableAutoSubDomain != other.enableAutoSubDomain) return false
        if (subDomainSettings != other.subDomainSettings) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.UpdateDomainAssociationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique ID for an Amplify app.
         */
        public var appId: kotlin.String? = null
        /**
         * Sets the branch patterns for automatic subdomain creation.
         */
        public var autoSubDomainCreationPatterns: List<String>? = null
        /**
         * The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains.
         */
        public var autoSubDomainIamRole: kotlin.String? = null
        /**
         * The name of the domain.
         */
        public var domainName: kotlin.String? = null
        /**
         * Enables the automated creation of subdomains for branches.
         */
        public var enableAutoSubDomain: kotlin.Boolean? = null
        /**
         * Describes the settings for the subdomain.
         */
        public var subDomainSettings: List<SubDomainSetting>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.UpdateDomainAssociationRequest) : this() {
            this.appId = x.appId
            this.autoSubDomainCreationPatterns = x.autoSubDomainCreationPatterns
            this.autoSubDomainIamRole = x.autoSubDomainIamRole
            this.domainName = x.domainName
            this.enableAutoSubDomain = x.enableAutoSubDomain
            this.subDomainSettings = x.subDomainSettings
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.UpdateDomainAssociationRequest = UpdateDomainAssociationRequest(this)
    }
}
