// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.transform

import aws.sdk.kotlin.services.amplify.model.Stage
import aws.sdk.kotlin.services.amplify.model.UpdateBranchRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateBranchOperationSerializer: HttpSerialize<UpdateBranchRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateBranchRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "apps",
                "${input.appId}".encodeLabel(),
                "branches",
                "${input.branchName}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateBranchOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateBranchOperationBody(context: ExecutionContext, input: UpdateBranchRequest): ByteArray {
    val serializer = JsonSerializer()
    val BACKENDENVIRONMENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("backendEnvironmentArn"))
    val BASICAUTHCREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("basicAuthCredentials"))
    val BUILDSPEC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("buildSpec"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("displayName"))
    val ENABLEAUTOBUILD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enableAutoBuild"))
    val ENABLEBASICAUTH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enableBasicAuth"))
    val ENABLENOTIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enableNotification"))
    val ENABLEPERFORMANCEMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enablePerformanceMode"))
    val ENABLEPULLREQUESTPREVIEW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enablePullRequestPreview"))
    val ENVIRONMENTVARIABLES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("environmentVariables"))
    val FRAMEWORK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("framework"))
    val PULLREQUESTENVIRONMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("pullRequestEnvironmentName"))
    val STAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("stage"))
    val TTL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ttl"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKENDENVIRONMENTARN_DESCRIPTOR)
        field(BASICAUTHCREDENTIALS_DESCRIPTOR)
        field(BUILDSPEC_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(ENABLEAUTOBUILD_DESCRIPTOR)
        field(ENABLEBASICAUTH_DESCRIPTOR)
        field(ENABLENOTIFICATION_DESCRIPTOR)
        field(ENABLEPERFORMANCEMODE_DESCRIPTOR)
        field(ENABLEPULLREQUESTPREVIEW_DESCRIPTOR)
        field(ENVIRONMENTVARIABLES_DESCRIPTOR)
        field(FRAMEWORK_DESCRIPTOR)
        field(PULLREQUESTENVIRONMENTNAME_DESCRIPTOR)
        field(STAGE_DESCRIPTOR)
        field(TTL_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.backendEnvironmentArn?.let { field(BACKENDENVIRONMENTARN_DESCRIPTOR, it) }
        input.basicAuthCredentials?.let { field(BASICAUTHCREDENTIALS_DESCRIPTOR, it) }
        input.buildSpec?.let { field(BUILDSPEC_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.displayName?.let { field(DISPLAYNAME_DESCRIPTOR, it) }
        input.enableAutoBuild?.let { field(ENABLEAUTOBUILD_DESCRIPTOR, it) }
        input.enableBasicAuth?.let { field(ENABLEBASICAUTH_DESCRIPTOR, it) }
        input.enableNotification?.let { field(ENABLENOTIFICATION_DESCRIPTOR, it) }
        input.enablePerformanceMode?.let { field(ENABLEPERFORMANCEMODE_DESCRIPTOR, it) }
        input.enablePullRequestPreview?.let { field(ENABLEPULLREQUESTPREVIEW_DESCRIPTOR, it) }
        if (input.environmentVariables != null) {
            mapField(ENVIRONMENTVARIABLES_DESCRIPTOR) {
                input.environmentVariables.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.framework?.let { field(FRAMEWORK_DESCRIPTOR, it) }
        input.pullRequestEnvironmentName?.let { field(PULLREQUESTENVIRONMENTNAME_DESCRIPTOR, it) }
        input.stage?.let { field(STAGE_DESCRIPTOR, it.value) }
        input.ttl?.let { field(TTL_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
