// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.transform

import aws.sdk.kotlin.services.amplify.model.AutoBranchCreationConfig
import aws.sdk.kotlin.services.amplify.model.CustomRule
import aws.sdk.kotlin.services.amplify.model.Platform
import aws.sdk.kotlin.services.amplify.model.UpdateAppRequest
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateAppOperationSerializer: HttpSerialize<UpdateAppRequest> {
    override suspend fun serialize(context: ExecutionContext, input: UpdateAppRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf(
                "apps",
                "${input.appId}".encodeLabel(),
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeUpdateAppOperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateAppOperationBody(context: ExecutionContext, input: UpdateAppRequest): ByteArray {
    val serializer = JsonSerializer()
    val ACCESSTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("accessToken"))
    val AUTOBRANCHCREATIONCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("autoBranchCreationConfig"))
    val AUTOBRANCHCREATIONPATTERNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("autoBranchCreationPatterns"))
    val BASICAUTHCREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("basicAuthCredentials"))
    val BUILDSPEC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("buildSpec"))
    val CUSTOMHEADERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("customHeaders"))
    val CUSTOMRULES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("customRules"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val ENABLEAUTOBRANCHCREATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enableAutoBranchCreation"))
    val ENABLEBASICAUTH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enableBasicAuth"))
    val ENABLEBRANCHAUTOBUILD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enableBranchAutoBuild"))
    val ENABLEBRANCHAUTODELETION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enableBranchAutoDeletion"))
    val ENVIRONMENTVARIABLES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("environmentVariables"))
    val IAMSERVICEROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("iamServiceRoleArn"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val OAUTHTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("oauthToken"))
    val PLATFORM_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("platform"))
    val REPOSITORY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("repository"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCESSTOKEN_DESCRIPTOR)
        field(AUTOBRANCHCREATIONCONFIG_DESCRIPTOR)
        field(AUTOBRANCHCREATIONPATTERNS_DESCRIPTOR)
        field(BASICAUTHCREDENTIALS_DESCRIPTOR)
        field(BUILDSPEC_DESCRIPTOR)
        field(CUSTOMHEADERS_DESCRIPTOR)
        field(CUSTOMRULES_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(ENABLEAUTOBRANCHCREATION_DESCRIPTOR)
        field(ENABLEBASICAUTH_DESCRIPTOR)
        field(ENABLEBRANCHAUTOBUILD_DESCRIPTOR)
        field(ENABLEBRANCHAUTODELETION_DESCRIPTOR)
        field(ENVIRONMENTVARIABLES_DESCRIPTOR)
        field(IAMSERVICEROLEARN_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(OAUTHTOKEN_DESCRIPTOR)
        field(PLATFORM_DESCRIPTOR)
        field(REPOSITORY_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.accessToken?.let { field(ACCESSTOKEN_DESCRIPTOR, it) }
        input.autoBranchCreationConfig?.let { field(AUTOBRANCHCREATIONCONFIG_DESCRIPTOR, it, ::serializeAutoBranchCreationConfigDocument) }
        if (input.autoBranchCreationPatterns != null) {
            listField(AUTOBRANCHCREATIONPATTERNS_DESCRIPTOR) {
                for (el0 in input.autoBranchCreationPatterns) {
                    serializeString(el0)
                }
            }
        }
        input.basicAuthCredentials?.let { field(BASICAUTHCREDENTIALS_DESCRIPTOR, it) }
        input.buildSpec?.let { field(BUILDSPEC_DESCRIPTOR, it) }
        input.customHeaders?.let { field(CUSTOMHEADERS_DESCRIPTOR, it) }
        if (input.customRules != null) {
            listField(CUSTOMRULES_DESCRIPTOR) {
                for (el0 in input.customRules) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeCustomRuleDocument))
                }
            }
        }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.enableAutoBranchCreation?.let { field(ENABLEAUTOBRANCHCREATION_DESCRIPTOR, it) }
        input.enableBasicAuth?.let { field(ENABLEBASICAUTH_DESCRIPTOR, it) }
        input.enableBranchAutoBuild?.let { field(ENABLEBRANCHAUTOBUILD_DESCRIPTOR, it) }
        input.enableBranchAutoDeletion?.let { field(ENABLEBRANCHAUTODELETION_DESCRIPTOR, it) }
        if (input.environmentVariables != null) {
            mapField(ENVIRONMENTVARIABLES_DESCRIPTOR) {
                input.environmentVariables.forEach { (key, value) -> entry(key, value) }
            }
        }
        input.iamServiceRoleArn?.let { field(IAMSERVICEROLEARN_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.oauthToken?.let { field(OAUTHTOKEN_DESCRIPTOR, it) }
        input.platform?.let { field(PLATFORM_DESCRIPTOR, it.value) }
        input.repository?.let { field(REPOSITORY_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
