// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the summary for an execution job for an Amplify app.
 */
public class JobSummary private constructor(builder: Builder) {
    /**
     * The commit ID from a third-party repository provider for the job.
     */
    public val commitId: kotlin.String? = builder.commitId
    /**
     * The commit message from a third-party repository provider for the job.
     */
    public val commitMessage: kotlin.String? = builder.commitMessage
    /**
     * The commit date and time for the job.
     */
    public val commitTime: aws.smithy.kotlin.runtime.time.Instant? = builder.commitTime
    /**
     * The end date and time for the job.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The Amazon Resource Name (ARN) for the job.
     */
    public val jobArn: kotlin.String? = builder.jobArn
    /**
     * The unique ID for the job.
     */
    public val jobId: kotlin.String? = builder.jobId
    /**
     * The type for the job. If the value is `RELEASE`, the job was manually released from its source by using the `StartJob` API. If the value is `RETRY`, the job was manually retried using the `StartJob` API. If the value is `WEB_HOOK`, the job was automatically triggered by webhooks.
     */
    public val jobType: aws.sdk.kotlin.services.amplify.model.JobType? = builder.jobType
    /**
     * The start date and time for the job.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * The current status for the job.
     */
    public val status: aws.sdk.kotlin.services.amplify.model.JobStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.JobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobSummary(")
        append("commitId=$commitId,")
        append("commitMessage=$commitMessage,")
        append("commitTime=$commitTime,")
        append("endTime=$endTime,")
        append("jobArn=$jobArn,")
        append("jobId=$jobId,")
        append("jobType=$jobType,")
        append("startTime=$startTime,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = commitId?.hashCode() ?: 0
        result = 31 * result + (commitMessage?.hashCode() ?: 0)
        result = 31 * result + (commitTime?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (jobArn?.hashCode() ?: 0)
        result = 31 * result + (jobId?.hashCode() ?: 0)
        result = 31 * result + (jobType?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobSummary

        if (commitId != other.commitId) return false
        if (commitMessage != other.commitMessage) return false
        if (commitTime != other.commitTime) return false
        if (endTime != other.endTime) return false
        if (jobArn != other.jobArn) return false
        if (jobId != other.jobId) return false
        if (jobType != other.jobType) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.JobSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The commit ID from a third-party repository provider for the job.
         */
        public var commitId: kotlin.String? = null
        /**
         * The commit message from a third-party repository provider for the job.
         */
        public var commitMessage: kotlin.String? = null
        /**
         * The commit date and time for the job.
         */
        public var commitTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The end date and time for the job.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) for the job.
         */
        public var jobArn: kotlin.String? = null
        /**
         * The unique ID for the job.
         */
        public var jobId: kotlin.String? = null
        /**
         * The type for the job. If the value is `RELEASE`, the job was manually released from its source by using the `StartJob` API. If the value is `RETRY`, the job was manually retried using the `StartJob` API. If the value is `WEB_HOOK`, the job was automatically triggered by webhooks.
         */
        public var jobType: aws.sdk.kotlin.services.amplify.model.JobType? = null
        /**
         * The start date and time for the job.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status for the job.
         */
        public var status: aws.sdk.kotlin.services.amplify.model.JobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.JobSummary) : this() {
            this.commitId = x.commitId
            this.commitMessage = x.commitMessage
            this.commitTime = x.commitTime
            this.endTime = x.endTime
            this.jobArn = x.jobArn
            this.jobId = x.jobId
            this.jobType = x.jobType
            this.startTime = x.startTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.JobSummary = JobSummary(this)
    }
}
