// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model



/**
 * Describes a domain association that associates a custom domain with an Amplify app.
 */
public class DomainAssociation private constructor(builder: Builder) {
    /**
     * Sets branch patterns for automatic subdomain creation.
     */
    public val autoSubDomainCreationPatterns: List<String>? = builder.autoSubDomainCreationPatterns
    /**
     * The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains.
     */
    public val autoSubDomainIamRole: kotlin.String? = builder.autoSubDomainIamRole
    /**
     * The DNS record for certificate verification.
     */
    public val certificateVerificationDnsRecord: kotlin.String? = builder.certificateVerificationDnsRecord
    /**
     * The Amazon Resource Name (ARN) for the domain association.
     */
    public val domainAssociationArn: kotlin.String? = builder.domainAssociationArn
    /**
     * The name of the domain.
     */
    public val domainName: kotlin.String? = builder.domainName
    /**
     * The current status of the domain association.
     */
    public val domainStatus: aws.sdk.kotlin.services.amplify.model.DomainStatus? = builder.domainStatus
    /**
     * Enables the automated creation of subdomains for branches.
     */
    public val enableAutoSubDomain: kotlin.Boolean? = builder.enableAutoSubDomain
    /**
     * The reason for the current status of the domain association.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The subdomains for the domain association.
     */
    public val subDomains: List<SubDomain>? = builder.subDomains

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.DomainAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainAssociation(")
        append("autoSubDomainCreationPatterns=$autoSubDomainCreationPatterns,")
        append("autoSubDomainIamRole=$autoSubDomainIamRole,")
        append("certificateVerificationDnsRecord=$certificateVerificationDnsRecord,")
        append("domainAssociationArn=$domainAssociationArn,")
        append("domainName=$domainName,")
        append("domainStatus=$domainStatus,")
        append("enableAutoSubDomain=$enableAutoSubDomain,")
        append("statusReason=$statusReason,")
        append("subDomains=$subDomains)")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoSubDomainCreationPatterns?.hashCode() ?: 0
        result = 31 * result + (autoSubDomainIamRole?.hashCode() ?: 0)
        result = 31 * result + (certificateVerificationDnsRecord?.hashCode() ?: 0)
        result = 31 * result + (domainAssociationArn?.hashCode() ?: 0)
        result = 31 * result + (domainName?.hashCode() ?: 0)
        result = 31 * result + (domainStatus?.hashCode() ?: 0)
        result = 31 * result + (enableAutoSubDomain?.hashCode() ?: 0)
        result = 31 * result + (statusReason?.hashCode() ?: 0)
        result = 31 * result + (subDomains?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainAssociation

        if (autoSubDomainCreationPatterns != other.autoSubDomainCreationPatterns) return false
        if (autoSubDomainIamRole != other.autoSubDomainIamRole) return false
        if (certificateVerificationDnsRecord != other.certificateVerificationDnsRecord) return false
        if (domainAssociationArn != other.domainAssociationArn) return false
        if (domainName != other.domainName) return false
        if (domainStatus != other.domainStatus) return false
        if (enableAutoSubDomain != other.enableAutoSubDomain) return false
        if (statusReason != other.statusReason) return false
        if (subDomains != other.subDomains) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.DomainAssociation = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Sets branch patterns for automatic subdomain creation.
         */
        public var autoSubDomainCreationPatterns: List<String>? = null
        /**
         * The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains.
         */
        public var autoSubDomainIamRole: kotlin.String? = null
        /**
         * The DNS record for certificate verification.
         */
        public var certificateVerificationDnsRecord: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the domain association.
         */
        public var domainAssociationArn: kotlin.String? = null
        /**
         * The name of the domain.
         */
        public var domainName: kotlin.String? = null
        /**
         * The current status of the domain association.
         */
        public var domainStatus: aws.sdk.kotlin.services.amplify.model.DomainStatus? = null
        /**
         * Enables the automated creation of subdomains for branches.
         */
        public var enableAutoSubDomain: kotlin.Boolean? = null
        /**
         * The reason for the current status of the domain association.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The subdomains for the domain association.
         */
        public var subDomains: List<SubDomain>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.DomainAssociation) : this() {
            this.autoSubDomainCreationPatterns = x.autoSubDomainCreationPatterns
            this.autoSubDomainIamRole = x.autoSubDomainIamRole
            this.certificateVerificationDnsRecord = x.certificateVerificationDnsRecord
            this.domainAssociationArn = x.domainAssociationArn
            this.domainName = x.domainName
            this.domainStatus = x.domainStatus
            this.enableAutoSubDomain = x.enableAutoSubDomain
            this.statusReason = x.statusReason
            this.subDomains = x.subDomains
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.DomainAssociation = DomainAssociation(this)
    }
}
