// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model



/**
 * The request structure for the create branch request.
 */
public class CreateBranchRequest private constructor(builder: Builder) {
    /**
     * The unique ID for an Amplify app.
     */
    public val appId: kotlin.String? = requireNotNull(builder.appId) { "A non-null value must be provided for appId" }
    /**
     * The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app.
     */
    public val backendEnvironmentArn: kotlin.String? = builder.backendEnvironmentArn
    /**
     * The basic authorization credentials for the branch. You must base64-encode the authorization credentials and provide them in the format `user:password`.
     */
    public val basicAuthCredentials: kotlin.String? = builder.basicAuthCredentials
    /**
     * The name for the branch.
     */
    public val branchName: kotlin.String? = builder.branchName
    /**
     * The build specification (build spec) for the branch.
     */
    public val buildSpec: kotlin.String? = builder.buildSpec
    /**
     * The description for the branch.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The display name for a branch. This is used as the default domain prefix.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * Enables auto building for the branch.
     */
    public val enableAutoBuild: kotlin.Boolean? = builder.enableAutoBuild
    /**
     * Enables basic authorization for the branch.
     */
    public val enableBasicAuth: kotlin.Boolean? = builder.enableBasicAuth
    /**
     * Enables notifications for the branch.
     */
    public val enableNotification: kotlin.Boolean? = builder.enableNotification
    /**
     * Enables performance mode for the branch.
     *
     * Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out.
     */
    public val enablePerformanceMode: kotlin.Boolean? = builder.enablePerformanceMode
    /**
     * Enables pull request previews for this branch.
     */
    public val enablePullRequestPreview: kotlin.Boolean? = builder.enablePullRequestPreview
    /**
     * The environment variables for the branch.
     */
    public val environmentVariables: Map<String, String>? = builder.environmentVariables
    /**
     * The framework for the branch.
     */
    public val framework: kotlin.String? = builder.framework
    /**
     * The Amplify environment name for the pull request.
     */
    public val pullRequestEnvironmentName: kotlin.String? = builder.pullRequestEnvironmentName
    /**
     * Describes the current stage for the branch.
     */
    public val stage: aws.sdk.kotlin.services.amplify.model.Stage? = builder.stage
    /**
     * The tag for the branch.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The content Time To Live (TTL) for the website in seconds.
     */
    public val ttl: kotlin.String? = builder.ttl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.CreateBranchRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBranchRequest(")
        append("appId=$appId,")
        append("backendEnvironmentArn=$backendEnvironmentArn,")
        append("basicAuthCredentials=*** Sensitive Data Redacted ***,")
        append("branchName=$branchName,")
        append("buildSpec=*** Sensitive Data Redacted ***,")
        append("description=$description,")
        append("displayName=$displayName,")
        append("enableAutoBuild=$enableAutoBuild,")
        append("enableBasicAuth=$enableBasicAuth,")
        append("enableNotification=$enableNotification,")
        append("enablePerformanceMode=$enablePerformanceMode,")
        append("enablePullRequestPreview=$enablePullRequestPreview,")
        append("environmentVariables=$environmentVariables,")
        append("framework=$framework,")
        append("pullRequestEnvironmentName=$pullRequestEnvironmentName,")
        append("stage=$stage,")
        append("tags=$tags,")
        append("ttl=$ttl)")
    }

    override fun hashCode(): kotlin.Int {
        var result = appId?.hashCode() ?: 0
        result = 31 * result + (backendEnvironmentArn?.hashCode() ?: 0)
        result = 31 * result + (basicAuthCredentials?.hashCode() ?: 0)
        result = 31 * result + (branchName?.hashCode() ?: 0)
        result = 31 * result + (buildSpec?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (enableAutoBuild?.hashCode() ?: 0)
        result = 31 * result + (enableBasicAuth?.hashCode() ?: 0)
        result = 31 * result + (enableNotification?.hashCode() ?: 0)
        result = 31 * result + (enablePerformanceMode?.hashCode() ?: 0)
        result = 31 * result + (enablePullRequestPreview?.hashCode() ?: 0)
        result = 31 * result + (environmentVariables?.hashCode() ?: 0)
        result = 31 * result + (framework?.hashCode() ?: 0)
        result = 31 * result + (pullRequestEnvironmentName?.hashCode() ?: 0)
        result = 31 * result + (stage?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (ttl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBranchRequest

        if (appId != other.appId) return false
        if (backendEnvironmentArn != other.backendEnvironmentArn) return false
        if (basicAuthCredentials != other.basicAuthCredentials) return false
        if (branchName != other.branchName) return false
        if (buildSpec != other.buildSpec) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (enableAutoBuild != other.enableAutoBuild) return false
        if (enableBasicAuth != other.enableBasicAuth) return false
        if (enableNotification != other.enableNotification) return false
        if (enablePerformanceMode != other.enablePerformanceMode) return false
        if (enablePullRequestPreview != other.enablePullRequestPreview) return false
        if (environmentVariables != other.environmentVariables) return false
        if (framework != other.framework) return false
        if (pullRequestEnvironmentName != other.pullRequestEnvironmentName) return false
        if (stage != other.stage) return false
        if (tags != other.tags) return false
        if (ttl != other.ttl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.CreateBranchRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The unique ID for an Amplify app.
         */
        public var appId: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app.
         */
        public var backendEnvironmentArn: kotlin.String? = null
        /**
         * The basic authorization credentials for the branch. You must base64-encode the authorization credentials and provide them in the format `user:password`.
         */
        public var basicAuthCredentials: kotlin.String? = null
        /**
         * The name for the branch.
         */
        public var branchName: kotlin.String? = null
        /**
         * The build specification (build spec) for the branch.
         */
        public var buildSpec: kotlin.String? = null
        /**
         * The description for the branch.
         */
        public var description: kotlin.String? = null
        /**
         * The display name for a branch. This is used as the default domain prefix.
         */
        public var displayName: kotlin.String? = null
        /**
         * Enables auto building for the branch.
         */
        public var enableAutoBuild: kotlin.Boolean? = null
        /**
         * Enables basic authorization for the branch.
         */
        public var enableBasicAuth: kotlin.Boolean? = null
        /**
         * Enables notifications for the branch.
         */
        public var enableNotification: kotlin.Boolean? = null
        /**
         * Enables performance mode for the branch.
         *
         * Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out.
         */
        public var enablePerformanceMode: kotlin.Boolean? = null
        /**
         * Enables pull request previews for this branch.
         */
        public var enablePullRequestPreview: kotlin.Boolean? = null
        /**
         * The environment variables for the branch.
         */
        public var environmentVariables: Map<String, String>? = null
        /**
         * The framework for the branch.
         */
        public var framework: kotlin.String? = null
        /**
         * The Amplify environment name for the pull request.
         */
        public var pullRequestEnvironmentName: kotlin.String? = null
        /**
         * Describes the current stage for the branch.
         */
        public var stage: aws.sdk.kotlin.services.amplify.model.Stage? = null
        /**
         * The tag for the branch.
         */
        public var tags: Map<String, String>? = null
        /**
         * The content Time To Live (TTL) for the website in seconds.
         */
        public var ttl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.CreateBranchRequest) : this() {
            this.appId = x.appId
            this.backendEnvironmentArn = x.backendEnvironmentArn
            this.basicAuthCredentials = x.basicAuthCredentials
            this.branchName = x.branchName
            this.buildSpec = x.buildSpec
            this.description = x.description
            this.displayName = x.displayName
            this.enableAutoBuild = x.enableAutoBuild
            this.enableBasicAuth = x.enableBasicAuth
            this.enableNotification = x.enableNotification
            this.enablePerformanceMode = x.enablePerformanceMode
            this.enablePullRequestPreview = x.enablePullRequestPreview
            this.environmentVariables = x.environmentVariables
            this.framework = x.framework
            this.pullRequestEnvironmentName = x.pullRequestEnvironmentName
            this.stage = x.stage
            this.tags = x.tags
            this.ttl = x.ttl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.CreateBranchRequest = CreateBranchRequest(this)
    }
}
