// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model



/**
 * The request structure used to create apps in Amplify.
 */
public class CreateAppRequest private constructor(builder: Builder) {
    /**
     * The personal access token for a GitHub repository for an Amplify app. The personal access token is used to authorize access to a GitHub repository using the Amplify GitHub App. The token is not stored.
     *
     * Use `accessToken` for GitHub repositories only. To authorize access to a repository provider such as Bitbucket or CodeCommit, use `oauthToken`.
     *
     * You must specify either `accessToken` or `oauthToken` when you create a new app.
     *
     * Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see [Migrating an existing OAuth app to the Amplify GitHub App](https://docs.aws.amazon.com/amplify/latest/UserGuide/setting-up-GitHub-access.html#migrating-to-github-app-auth) in the *Amplify User Guide* .
     */
    public val accessToken: kotlin.String? = builder.accessToken
    /**
     * The automated branch creation configuration for an Amplify app.
     */
    public val autoBranchCreationConfig: aws.sdk.kotlin.services.amplify.model.AutoBranchCreationConfig? = builder.autoBranchCreationConfig
    /**
     * The automated branch creation glob patterns for an Amplify app.
     */
    public val autoBranchCreationPatterns: List<String>? = builder.autoBranchCreationPatterns
    /**
     * The credentials for basic authorization for an Amplify app. You must base64-encode the authorization credentials and provide them in the format `user:password`.
     */
    public val basicAuthCredentials: kotlin.String? = builder.basicAuthCredentials
    /**
     * The build specification (build spec) for an Amplify app.
     */
    public val buildSpec: kotlin.String? = builder.buildSpec
    /**
     * The custom HTTP headers for an Amplify app.
     */
    public val customHeaders: kotlin.String? = builder.customHeaders
    /**
     * The custom rewrite and redirect rules for an Amplify app.
     */
    public val customRules: List<CustomRule>? = builder.customRules
    /**
     * The description for an Amplify app.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Enables automated branch creation for an Amplify app.
     */
    public val enableAutoBranchCreation: kotlin.Boolean? = builder.enableAutoBranchCreation
    /**
     * Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
     */
    public val enableBasicAuth: kotlin.Boolean? = builder.enableBasicAuth
    /**
     * Enables the auto building of branches for an Amplify app.
     */
    public val enableBranchAutoBuild: kotlin.Boolean? = builder.enableBranchAutoBuild
    /**
     * Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
     */
    public val enableBranchAutoDeletion: kotlin.Boolean? = builder.enableBranchAutoDeletion
    /**
     * The environment variables map for an Amplify app.
     */
    public val environmentVariables: Map<String, String>? = builder.environmentVariables
    /**
     * The AWS Identity and Access Management (IAM) service role for an Amplify app.
     */
    public val iamServiceRoleArn: kotlin.String? = builder.iamServiceRoleArn
    /**
     * The name for an Amplify app.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key using SSH cloning. The OAuth token is not stored.
     *
     * Use `oauthToken` for repository providers other than GitHub, such as Bitbucket or CodeCommit. To authorize access to GitHub as your repository provider, use `accessToken`.
     *
     * You must specify either `oauthToken` or `accessToken` when you create a new app.
     *
     * Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see [Migrating an existing OAuth app to the Amplify GitHub App](https://docs.aws.amazon.com/amplify/latest/UserGuide/setting-up-GitHub-access.html#migrating-to-github-app-auth) in the *Amplify User Guide* .
     */
    public val oauthToken: kotlin.String? = builder.oauthToken
    /**
     * The platform or framework for an Amplify app.
     */
    public val platform: aws.sdk.kotlin.services.amplify.model.Platform? = builder.platform
    /**
     * The repository for an Amplify app.
     */
    public val repository: kotlin.String? = builder.repository
    /**
     * The tag for an Amplify app.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.CreateAppRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAppRequest(")
        append("accessToken=*** Sensitive Data Redacted ***,")
        append("autoBranchCreationConfig=$autoBranchCreationConfig,")
        append("autoBranchCreationPatterns=$autoBranchCreationPatterns,")
        append("basicAuthCredentials=*** Sensitive Data Redacted ***,")
        append("buildSpec=*** Sensitive Data Redacted ***,")
        append("customHeaders=$customHeaders,")
        append("customRules=$customRules,")
        append("description=$description,")
        append("enableAutoBranchCreation=$enableAutoBranchCreation,")
        append("enableBasicAuth=$enableBasicAuth,")
        append("enableBranchAutoBuild=$enableBranchAutoBuild,")
        append("enableBranchAutoDeletion=$enableBranchAutoDeletion,")
        append("environmentVariables=$environmentVariables,")
        append("iamServiceRoleArn=$iamServiceRoleArn,")
        append("name=$name,")
        append("oauthToken=*** Sensitive Data Redacted ***,")
        append("platform=$platform,")
        append("repository=$repository,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessToken?.hashCode() ?: 0
        result = 31 * result + (autoBranchCreationConfig?.hashCode() ?: 0)
        result = 31 * result + (autoBranchCreationPatterns?.hashCode() ?: 0)
        result = 31 * result + (basicAuthCredentials?.hashCode() ?: 0)
        result = 31 * result + (buildSpec?.hashCode() ?: 0)
        result = 31 * result + (customHeaders?.hashCode() ?: 0)
        result = 31 * result + (customRules?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (enableAutoBranchCreation?.hashCode() ?: 0)
        result = 31 * result + (enableBasicAuth?.hashCode() ?: 0)
        result = 31 * result + (enableBranchAutoBuild?.hashCode() ?: 0)
        result = 31 * result + (enableBranchAutoDeletion?.hashCode() ?: 0)
        result = 31 * result + (environmentVariables?.hashCode() ?: 0)
        result = 31 * result + (iamServiceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (oauthToken?.hashCode() ?: 0)
        result = 31 * result + (platform?.hashCode() ?: 0)
        result = 31 * result + (repository?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAppRequest

        if (accessToken != other.accessToken) return false
        if (autoBranchCreationConfig != other.autoBranchCreationConfig) return false
        if (autoBranchCreationPatterns != other.autoBranchCreationPatterns) return false
        if (basicAuthCredentials != other.basicAuthCredentials) return false
        if (buildSpec != other.buildSpec) return false
        if (customHeaders != other.customHeaders) return false
        if (customRules != other.customRules) return false
        if (description != other.description) return false
        if (enableAutoBranchCreation != other.enableAutoBranchCreation) return false
        if (enableBasicAuth != other.enableBasicAuth) return false
        if (enableBranchAutoBuild != other.enableBranchAutoBuild) return false
        if (enableBranchAutoDeletion != other.enableBranchAutoDeletion) return false
        if (environmentVariables != other.environmentVariables) return false
        if (iamServiceRoleArn != other.iamServiceRoleArn) return false
        if (name != other.name) return false
        if (oauthToken != other.oauthToken) return false
        if (platform != other.platform) return false
        if (repository != other.repository) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.CreateAppRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The personal access token for a GitHub repository for an Amplify app. The personal access token is used to authorize access to a GitHub repository using the Amplify GitHub App. The token is not stored.
         *
         * Use `accessToken` for GitHub repositories only. To authorize access to a repository provider such as Bitbucket or CodeCommit, use `oauthToken`.
         *
         * You must specify either `accessToken` or `oauthToken` when you create a new app.
         *
         * Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see [Migrating an existing OAuth app to the Amplify GitHub App](https://docs.aws.amazon.com/amplify/latest/UserGuide/setting-up-GitHub-access.html#migrating-to-github-app-auth) in the *Amplify User Guide* .
         */
        public var accessToken: kotlin.String? = null
        /**
         * The automated branch creation configuration for an Amplify app.
         */
        public var autoBranchCreationConfig: aws.sdk.kotlin.services.amplify.model.AutoBranchCreationConfig? = null
        /**
         * The automated branch creation glob patterns for an Amplify app.
         */
        public var autoBranchCreationPatterns: List<String>? = null
        /**
         * The credentials for basic authorization for an Amplify app. You must base64-encode the authorization credentials and provide them in the format `user:password`.
         */
        public var basicAuthCredentials: kotlin.String? = null
        /**
         * The build specification (build spec) for an Amplify app.
         */
        public var buildSpec: kotlin.String? = null
        /**
         * The custom HTTP headers for an Amplify app.
         */
        public var customHeaders: kotlin.String? = null
        /**
         * The custom rewrite and redirect rules for an Amplify app.
         */
        public var customRules: List<CustomRule>? = null
        /**
         * The description for an Amplify app.
         */
        public var description: kotlin.String? = null
        /**
         * Enables automated branch creation for an Amplify app.
         */
        public var enableAutoBranchCreation: kotlin.Boolean? = null
        /**
         * Enables basic authorization for an Amplify app. This will apply to all branches that are part of this app.
         */
        public var enableBasicAuth: kotlin.Boolean? = null
        /**
         * Enables the auto building of branches for an Amplify app.
         */
        public var enableBranchAutoBuild: kotlin.Boolean? = null
        /**
         * Automatically disconnects a branch in the Amplify Console when you delete a branch from your Git repository.
         */
        public var enableBranchAutoDeletion: kotlin.Boolean? = null
        /**
         * The environment variables map for an Amplify app.
         */
        public var environmentVariables: Map<String, String>? = null
        /**
         * The AWS Identity and Access Management (IAM) service role for an Amplify app.
         */
        public var iamServiceRoleArn: kotlin.String? = null
        /**
         * The name for an Amplify app.
         */
        public var name: kotlin.String? = null
        /**
         * The OAuth token for a third-party source control system for an Amplify app. The OAuth token is used to create a webhook and a read-only deploy key using SSH cloning. The OAuth token is not stored.
         *
         * Use `oauthToken` for repository providers other than GitHub, such as Bitbucket or CodeCommit. To authorize access to GitHub as your repository provider, use `accessToken`.
         *
         * You must specify either `oauthToken` or `accessToken` when you create a new app.
         *
         * Existing Amplify apps deployed from a GitHub repository using OAuth continue to work with CI/CD. However, we strongly recommend that you migrate these apps to use the GitHub App. For more information, see [Migrating an existing OAuth app to the Amplify GitHub App](https://docs.aws.amazon.com/amplify/latest/UserGuide/setting-up-GitHub-access.html#migrating-to-github-app-auth) in the *Amplify User Guide* .
         */
        public var oauthToken: kotlin.String? = null
        /**
         * The platform or framework for an Amplify app.
         */
        public var platform: aws.sdk.kotlin.services.amplify.model.Platform? = null
        /**
         * The repository for an Amplify app.
         */
        public var repository: kotlin.String? = null
        /**
         * The tag for an Amplify app.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.CreateAppRequest) : this() {
            this.accessToken = x.accessToken
            this.autoBranchCreationConfig = x.autoBranchCreationConfig
            this.autoBranchCreationPatterns = x.autoBranchCreationPatterns
            this.basicAuthCredentials = x.basicAuthCredentials
            this.buildSpec = x.buildSpec
            this.customHeaders = x.customHeaders
            this.customRules = x.customRules
            this.description = x.description
            this.enableAutoBranchCreation = x.enableAutoBranchCreation
            this.enableBasicAuth = x.enableBasicAuth
            this.enableBranchAutoBuild = x.enableBranchAutoBuild
            this.enableBranchAutoDeletion = x.enableBranchAutoDeletion
            this.environmentVariables = x.environmentVariables
            this.iamServiceRoleArn = x.iamServiceRoleArn
            this.name = x.name
            this.oauthToken = x.oauthToken
            this.platform = x.platform
            this.repository = x.repository
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.CreateAppRequest = CreateAppRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.amplify.model.AutoBranchCreationConfig] inside the given [block]
         */
        public fun autoBranchCreationConfig(block: aws.sdk.kotlin.services.amplify.model.AutoBranchCreationConfig.Builder.() -> kotlin.Unit) {
            this.autoBranchCreationConfig = aws.sdk.kotlin.services.amplify.model.AutoBranchCreationConfig.invoke(block)
        }
    }
}
