// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.ResolveAwsEndpoint
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.amplify.model.*
import aws.sdk.kotlin.services.amplify.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.auth.awssigning.middleware.AwsSigningMiddleware
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.util.putIfAbsent


public const val ServiceId: String = "Amplify"
public const val ServiceApiVersion: String = "2017-07-25"
public const val SdkVersion: String = "0.17.11-beta"

internal class DefaultAmplifyClient(override val config: AmplifyClient.Config) : AmplifyClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Creates a new Amplify app.
     */
    override suspend fun createApp(input: CreateAppRequest): CreateAppResponse {
        val op = SdkHttpOperation.build<CreateAppRequest, CreateAppResponse> {
            serializer = CreateAppOperationSerializer()
            deserializer = CreateAppOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateApp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new backend environment for an Amplify app.
     */
    override suspend fun createBackendEnvironment(input: CreateBackendEnvironmentRequest): CreateBackendEnvironmentResponse {
        val op = SdkHttpOperation.build<CreateBackendEnvironmentRequest, CreateBackendEnvironmentResponse> {
            serializer = CreateBackendEnvironmentOperationSerializer()
            deserializer = CreateBackendEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBackendEnvironment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new branch for an Amplify app.
     */
    override suspend fun createBranch(input: CreateBranchRequest): CreateBranchResponse {
        val op = SdkHttpOperation.build<CreateBranchRequest, CreateBranchResponse> {
            serializer = CreateBranchOperationSerializer()
            deserializer = CreateBranchOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateBranch"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a deployment for a manually deployed Amplify app. Manually deployed apps are not connected to a repository.
     */
    override suspend fun createDeployment(input: CreateDeploymentRequest): CreateDeploymentResponse {
        val op = SdkHttpOperation.build<CreateDeploymentRequest, CreateDeploymentResponse> {
            serializer = CreateDeploymentOperationSerializer()
            deserializer = CreateDeploymentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDeployment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new domain association for an Amplify app. This action associates a custom domain with the Amplify app
     */
    override suspend fun createDomainAssociation(input: CreateDomainAssociationRequest): CreateDomainAssociationResponse {
        val op = SdkHttpOperation.build<CreateDomainAssociationRequest, CreateDomainAssociationResponse> {
            serializer = CreateDomainAssociationOperationSerializer()
            deserializer = CreateDomainAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDomainAssociation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new webhook on an Amplify app.
     */
    override suspend fun createWebhook(input: CreateWebhookRequest): CreateWebhookResponse {
        val op = SdkHttpOperation.build<CreateWebhookRequest, CreateWebhookResponse> {
            serializer = CreateWebhookOperationSerializer()
            deserializer = CreateWebhookOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWebhook"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes an existing Amplify app specified by an app ID.
     */
    override suspend fun deleteApp(input: DeleteAppRequest): DeleteAppResponse {
        val op = SdkHttpOperation.build<DeleteAppRequest, DeleteAppResponse> {
            serializer = DeleteAppOperationSerializer()
            deserializer = DeleteAppOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteApp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a backend environment for an Amplify app.
     */
    override suspend fun deleteBackendEnvironment(input: DeleteBackendEnvironmentRequest): DeleteBackendEnvironmentResponse {
        val op = SdkHttpOperation.build<DeleteBackendEnvironmentRequest, DeleteBackendEnvironmentResponse> {
            serializer = DeleteBackendEnvironmentOperationSerializer()
            deserializer = DeleteBackendEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBackendEnvironment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a branch for an Amplify app.
     */
    override suspend fun deleteBranch(input: DeleteBranchRequest): DeleteBranchResponse {
        val op = SdkHttpOperation.build<DeleteBranchRequest, DeleteBranchResponse> {
            serializer = DeleteBranchOperationSerializer()
            deserializer = DeleteBranchOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteBranch"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a domain association for an Amplify app.
     */
    override suspend fun deleteDomainAssociation(input: DeleteDomainAssociationRequest): DeleteDomainAssociationResponse {
        val op = SdkHttpOperation.build<DeleteDomainAssociationRequest, DeleteDomainAssociationResponse> {
            serializer = DeleteDomainAssociationOperationSerializer()
            deserializer = DeleteDomainAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteDomainAssociation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a job for a branch of an Amplify app.
     */
    override suspend fun deleteJob(input: DeleteJobRequest): DeleteJobResponse {
        val op = SdkHttpOperation.build<DeleteJobRequest, DeleteJobResponse> {
            serializer = DeleteJobOperationSerializer()
            deserializer = DeleteJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a webhook.
     */
    override suspend fun deleteWebhook(input: DeleteWebhookRequest): DeleteWebhookResponse {
        val op = SdkHttpOperation.build<DeleteWebhookRequest, DeleteWebhookResponse> {
            serializer = DeleteWebhookOperationSerializer()
            deserializer = DeleteWebhookOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteWebhook"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the website access logs for a specific time range using a presigned URL.
     */
    override suspend fun generateAccessLogs(input: GenerateAccessLogsRequest): GenerateAccessLogsResponse {
        val op = SdkHttpOperation.build<GenerateAccessLogsRequest, GenerateAccessLogsResponse> {
            serializer = GenerateAccessLogsOperationSerializer()
            deserializer = GenerateAccessLogsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GenerateAccessLogs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns an existing Amplify app by appID.
     */
    override suspend fun getApp(input: GetAppRequest): GetAppResponse {
        val op = SdkHttpOperation.build<GetAppRequest, GetAppResponse> {
            serializer = GetAppOperationSerializer()
            deserializer = GetAppOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetApp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the artifact info that corresponds to an artifact id.
     */
    override suspend fun getArtifactUrl(input: GetArtifactUrlRequest): GetArtifactUrlResponse {
        val op = SdkHttpOperation.build<GetArtifactUrlRequest, GetArtifactUrlResponse> {
            serializer = GetArtifactUrlOperationSerializer()
            deserializer = GetArtifactUrlOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetArtifactUrl"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a backend environment for an Amplify app.
     */
    override suspend fun getBackendEnvironment(input: GetBackendEnvironmentRequest): GetBackendEnvironmentResponse {
        val op = SdkHttpOperation.build<GetBackendEnvironmentRequest, GetBackendEnvironmentResponse> {
            serializer = GetBackendEnvironmentOperationSerializer()
            deserializer = GetBackendEnvironmentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBackendEnvironment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a branch for an Amplify app.
     */
    override suspend fun getBranch(input: GetBranchRequest): GetBranchResponse {
        val op = SdkHttpOperation.build<GetBranchRequest, GetBranchResponse> {
            serializer = GetBranchOperationSerializer()
            deserializer = GetBranchOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBranch"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the domain information for an Amplify app.
     */
    override suspend fun getDomainAssociation(input: GetDomainAssociationRequest): GetDomainAssociationResponse {
        val op = SdkHttpOperation.build<GetDomainAssociationRequest, GetDomainAssociationResponse> {
            serializer = GetDomainAssociationOperationSerializer()
            deserializer = GetDomainAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDomainAssociation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a job for a branch of an Amplify app.
     */
    override suspend fun getJob(input: GetJobRequest): GetJobResponse {
        val op = SdkHttpOperation.build<GetJobRequest, GetJobResponse> {
            serializer = GetJobOperationSerializer()
            deserializer = GetJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the webhook information that corresponds to a specified webhook ID.
     */
    override suspend fun getWebhook(input: GetWebhookRequest): GetWebhookResponse {
        val op = SdkHttpOperation.build<GetWebhookRequest, GetWebhookResponse> {
            serializer = GetWebhookOperationSerializer()
            deserializer = GetWebhookOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetWebhook"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of the existing Amplify apps.
     */
    override suspend fun listApps(input: ListAppsRequest): ListAppsResponse {
        val op = SdkHttpOperation.build<ListAppsRequest, ListAppsResponse> {
            serializer = ListAppsOperationSerializer()
            deserializer = ListAppsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListApps"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of artifacts for a specified app, branch, and job.
     */
    override suspend fun listArtifacts(input: ListArtifactsRequest): ListArtifactsResponse {
        val op = SdkHttpOperation.build<ListArtifactsRequest, ListArtifactsResponse> {
            serializer = ListArtifactsOperationSerializer()
            deserializer = ListArtifactsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListArtifacts"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the backend environments for an Amplify app.
     */
    override suspend fun listBackendEnvironments(input: ListBackendEnvironmentsRequest): ListBackendEnvironmentsResponse {
        val op = SdkHttpOperation.build<ListBackendEnvironmentsRequest, ListBackendEnvironmentsResponse> {
            serializer = ListBackendEnvironmentsOperationSerializer()
            deserializer = ListBackendEnvironmentsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBackendEnvironments"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the branches of an Amplify app.
     */
    override suspend fun listBranches(input: ListBranchesRequest): ListBranchesResponse {
        val op = SdkHttpOperation.build<ListBranchesRequest, ListBranchesResponse> {
            serializer = ListBranchesOperationSerializer()
            deserializer = ListBranchesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListBranches"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns the domain associations for an Amplify app.
     */
    override suspend fun listDomainAssociations(input: ListDomainAssociationsRequest): ListDomainAssociationsResponse {
        val op = SdkHttpOperation.build<ListDomainAssociationsRequest, ListDomainAssociationsResponse> {
            serializer = ListDomainAssociationsOperationSerializer()
            deserializer = ListDomainAssociationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDomainAssociations"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Lists the jobs for a branch of an Amplify app.
     */
    override suspend fun listJobs(input: ListJobsRequest): ListJobsResponse {
        val op = SdkHttpOperation.build<ListJobsRequest, ListJobsResponse> {
            serializer = ListJobsOperationSerializer()
            deserializer = ListJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListJobs"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of tags for a specified Amazon Resource Name (ARN).
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Returns a list of webhooks for an Amplify app.
     */
    override suspend fun listWebhooks(input: ListWebhooksRequest): ListWebhooksResponse {
        val op = SdkHttpOperation.build<ListWebhooksRequest, ListWebhooksResponse> {
            serializer = ListWebhooksOperationSerializer()
            deserializer = ListWebhooksOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWebhooks"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a deployment for a manually deployed app. Manually deployed apps are not connected to a repository.
     */
    override suspend fun startDeployment(input: StartDeploymentRequest): StartDeploymentResponse {
        val op = SdkHttpOperation.build<StartDeploymentRequest, StartDeploymentResponse> {
            serializer = StartDeploymentOperationSerializer()
            deserializer = StartDeploymentOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartDeployment"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Starts a new job for a branch of an Amplify app.
     */
    override suspend fun startJob(input: StartJobRequest): StartJobResponse {
        val op = SdkHttpOperation.build<StartJobRequest, StartJobResponse> {
            serializer = StartJobOperationSerializer()
            deserializer = StartJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Stops a job that is in progress for a branch of an Amplify app.
     */
    override suspend fun stopJob(input: StopJobRequest): StopJobResponse {
        val op = SdkHttpOperation.build<StopJobRequest, StopJobResponse> {
            serializer = StopJobOperationSerializer()
            deserializer = StopJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StopJob"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Tags the resource with a tag key and value.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Untags a resource with a specified Amazon Resource Name (ARN).
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates an existing Amplify app.
     */
    override suspend fun updateApp(input: UpdateAppRequest): UpdateAppResponse {
        val op = SdkHttpOperation.build<UpdateAppRequest, UpdateAppResponse> {
            serializer = UpdateAppOperationSerializer()
            deserializer = UpdateAppOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateApp"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a branch for an Amplify app.
     */
    override suspend fun updateBranch(input: UpdateBranchRequest): UpdateBranchResponse {
        val op = SdkHttpOperation.build<UpdateBranchRequest, UpdateBranchResponse> {
            serializer = UpdateBranchOperationSerializer()
            deserializer = UpdateBranchOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateBranch"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new domain association for an Amplify app.
     */
    override suspend fun updateDomainAssociation(input: UpdateDomainAssociationRequest): UpdateDomainAssociationResponse {
        val op = SdkHttpOperation.build<UpdateDomainAssociationRequest, UpdateDomainAssociationResponse> {
            serializer = UpdateDomainAssociationOperationSerializer()
            deserializer = UpdateDomainAssociationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateDomainAssociation"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    /**
     * Updates a webhook.
     */
    override suspend fun updateWebhook(input: UpdateWebhookRequest): UpdateWebhookResponse {
        val op = SdkHttpOperation.build<UpdateWebhookRequest, UpdateWebhookResponse> {
            serializer = UpdateWebhookOperationSerializer()
            deserializer = UpdateWebhookOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateWebhook"
            }
        }
        mergeServiceDefaults(op.context)
        op.install(ResolveAwsEndpoint(ServiceId, config.endpointResolver))
        op.install(AwsRetryMiddleware(config.retryStrategy, AwsDefaultRetryPolicy))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.install(
            AwsSigningMiddleware {
                this.signer = config.signer
                this.credentialsProvider = config.credentialsProvider
                this.service = "amplify"
            }
        )
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "amplify")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
    }
}
