// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.amplify.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.amplify.model.*
import aws.sdk.kotlin.services.amplify.model.CreateAppRequest
import aws.sdk.kotlin.services.amplify.model.CreateAppResponse
import aws.sdk.kotlin.services.amplify.model.CreateBackendEnvironmentRequest
import aws.sdk.kotlin.services.amplify.model.CreateBackendEnvironmentResponse
import aws.sdk.kotlin.services.amplify.model.CreateBranchRequest
import aws.sdk.kotlin.services.amplify.model.CreateBranchResponse
import aws.sdk.kotlin.services.amplify.model.CreateDeploymentRequest
import aws.sdk.kotlin.services.amplify.model.CreateDeploymentResponse
import aws.sdk.kotlin.services.amplify.model.CreateDomainAssociationRequest
import aws.sdk.kotlin.services.amplify.model.CreateDomainAssociationResponse
import aws.sdk.kotlin.services.amplify.model.CreateWebhookRequest
import aws.sdk.kotlin.services.amplify.model.CreateWebhookResponse
import aws.sdk.kotlin.services.amplify.model.DeleteAppRequest
import aws.sdk.kotlin.services.amplify.model.DeleteAppResponse
import aws.sdk.kotlin.services.amplify.model.DeleteBackendEnvironmentRequest
import aws.sdk.kotlin.services.amplify.model.DeleteBackendEnvironmentResponse
import aws.sdk.kotlin.services.amplify.model.DeleteBranchRequest
import aws.sdk.kotlin.services.amplify.model.DeleteBranchResponse
import aws.sdk.kotlin.services.amplify.model.DeleteDomainAssociationRequest
import aws.sdk.kotlin.services.amplify.model.DeleteDomainAssociationResponse
import aws.sdk.kotlin.services.amplify.model.DeleteJobRequest
import aws.sdk.kotlin.services.amplify.model.DeleteJobResponse
import aws.sdk.kotlin.services.amplify.model.DeleteWebhookRequest
import aws.sdk.kotlin.services.amplify.model.DeleteWebhookResponse
import aws.sdk.kotlin.services.amplify.model.GenerateAccessLogsRequest
import aws.sdk.kotlin.services.amplify.model.GenerateAccessLogsResponse
import aws.sdk.kotlin.services.amplify.model.GetAppRequest
import aws.sdk.kotlin.services.amplify.model.GetAppResponse
import aws.sdk.kotlin.services.amplify.model.GetArtifactUrlRequest
import aws.sdk.kotlin.services.amplify.model.GetArtifactUrlResponse
import aws.sdk.kotlin.services.amplify.model.GetBackendEnvironmentRequest
import aws.sdk.kotlin.services.amplify.model.GetBackendEnvironmentResponse
import aws.sdk.kotlin.services.amplify.model.GetBranchRequest
import aws.sdk.kotlin.services.amplify.model.GetBranchResponse
import aws.sdk.kotlin.services.amplify.model.GetDomainAssociationRequest
import aws.sdk.kotlin.services.amplify.model.GetDomainAssociationResponse
import aws.sdk.kotlin.services.amplify.model.GetJobRequest
import aws.sdk.kotlin.services.amplify.model.GetJobResponse
import aws.sdk.kotlin.services.amplify.model.GetWebhookRequest
import aws.sdk.kotlin.services.amplify.model.GetWebhookResponse
import aws.sdk.kotlin.services.amplify.model.ListAppsRequest
import aws.sdk.kotlin.services.amplify.model.ListAppsResponse
import aws.sdk.kotlin.services.amplify.model.ListArtifactsRequest
import aws.sdk.kotlin.services.amplify.model.ListArtifactsResponse
import aws.sdk.kotlin.services.amplify.model.ListBackendEnvironmentsRequest
import aws.sdk.kotlin.services.amplify.model.ListBackendEnvironmentsResponse
import aws.sdk.kotlin.services.amplify.model.ListBranchesRequest
import aws.sdk.kotlin.services.amplify.model.ListBranchesResponse
import aws.sdk.kotlin.services.amplify.model.ListDomainAssociationsRequest
import aws.sdk.kotlin.services.amplify.model.ListDomainAssociationsResponse
import aws.sdk.kotlin.services.amplify.model.ListJobsRequest
import aws.sdk.kotlin.services.amplify.model.ListJobsResponse
import aws.sdk.kotlin.services.amplify.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.amplify.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.amplify.model.ListWebhooksRequest
import aws.sdk.kotlin.services.amplify.model.ListWebhooksResponse
import aws.sdk.kotlin.services.amplify.model.StartDeploymentRequest
import aws.sdk.kotlin.services.amplify.model.StartDeploymentResponse
import aws.sdk.kotlin.services.amplify.model.StartJobRequest
import aws.sdk.kotlin.services.amplify.model.StartJobResponse
import aws.sdk.kotlin.services.amplify.model.StopJobRequest
import aws.sdk.kotlin.services.amplify.model.StopJobResponse
import aws.sdk.kotlin.services.amplify.model.TagResourceRequest
import aws.sdk.kotlin.services.amplify.model.TagResourceResponse
import aws.sdk.kotlin.services.amplify.model.UntagResourceRequest
import aws.sdk.kotlin.services.amplify.model.UntagResourceResponse
import aws.sdk.kotlin.services.amplify.model.UpdateAppRequest
import aws.sdk.kotlin.services.amplify.model.UpdateAppResponse
import aws.sdk.kotlin.services.amplify.model.UpdateBranchRequest
import aws.sdk.kotlin.services.amplify.model.UpdateBranchResponse
import aws.sdk.kotlin.services.amplify.model.UpdateDomainAssociationRequest
import aws.sdk.kotlin.services.amplify.model.UpdateDomainAssociationResponse
import aws.sdk.kotlin.services.amplify.model.UpdateWebhookRequest
import aws.sdk.kotlin.services.amplify.model.UpdateWebhookResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.endpoints.EndpointResolver
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy

/**
 * Amplify enables developers to develop and deploy cloud-powered mobile and web apps. The Amplify Console provides a continuous delivery and hosting service for web applications. For more information, see the [Amplify Console User Guide](https://docs.aws.amazon.com/amplify/latest/userguide/welcome.html). The Amplify Framework is a comprehensive set of SDKs, libraries, tools, and documentation for client app development. For more information, see the [Amplify Framework.](https://docs.amplify.aws/)
 */
public interface AmplifyClient : SdkClient {

    override val serviceName: String
        get() = "Amplify"
    /**
     * AmplifyClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): AmplifyClient {
            val config = Config.Builder().apply(block).build()
            return DefaultAmplifyClient(config)
        }

        public operator fun invoke(config: Config): AmplifyClient = DefaultAmplifyClient(config)

        /**
         * Construct a [AmplifyClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): AmplifyClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultAmplifyClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null
            /**
             * AWS region to make requests to
             */
            public var region: String? = null
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null
            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            public var endpointResolver: AwsEndpointResolver? = null
            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null
            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default
            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a new Amplify app.
     */
    public suspend fun createApp(input: CreateAppRequest): CreateAppResponse

    /**
     * Creates a new backend environment for an Amplify app.
     */
    public suspend fun createBackendEnvironment(input: CreateBackendEnvironmentRequest): CreateBackendEnvironmentResponse

    /**
     * Creates a new branch for an Amplify app.
     */
    public suspend fun createBranch(input: CreateBranchRequest): CreateBranchResponse

    /**
     * Creates a deployment for a manually deployed Amplify app. Manually deployed apps are not connected to a repository.
     */
    public suspend fun createDeployment(input: CreateDeploymentRequest): CreateDeploymentResponse

    /**
     * Creates a new domain association for an Amplify app. This action associates a custom domain with the Amplify app
     */
    public suspend fun createDomainAssociation(input: CreateDomainAssociationRequest): CreateDomainAssociationResponse

    /**
     * Creates a new webhook on an Amplify app.
     */
    public suspend fun createWebhook(input: CreateWebhookRequest): CreateWebhookResponse

    /**
     * Deletes an existing Amplify app specified by an app ID.
     */
    public suspend fun deleteApp(input: DeleteAppRequest): DeleteAppResponse

    /**
     * Deletes a backend environment for an Amplify app.
     */
    public suspend fun deleteBackendEnvironment(input: DeleteBackendEnvironmentRequest): DeleteBackendEnvironmentResponse

    /**
     * Deletes a branch for an Amplify app.
     */
    public suspend fun deleteBranch(input: DeleteBranchRequest): DeleteBranchResponse

    /**
     * Deletes a domain association for an Amplify app.
     */
    public suspend fun deleteDomainAssociation(input: DeleteDomainAssociationRequest): DeleteDomainAssociationResponse

    /**
     * Deletes a job for a branch of an Amplify app.
     */
    public suspend fun deleteJob(input: DeleteJobRequest): DeleteJobResponse

    /**
     * Deletes a webhook.
     */
    public suspend fun deleteWebhook(input: DeleteWebhookRequest): DeleteWebhookResponse

    /**
     * Returns the website access logs for a specific time range using a presigned URL.
     */
    public suspend fun generateAccessLogs(input: GenerateAccessLogsRequest): GenerateAccessLogsResponse

    /**
     * Returns an existing Amplify app by appID.
     */
    public suspend fun getApp(input: GetAppRequest): GetAppResponse

    /**
     * Returns the artifact info that corresponds to an artifact id.
     */
    public suspend fun getArtifactUrl(input: GetArtifactUrlRequest): GetArtifactUrlResponse

    /**
     * Returns a backend environment for an Amplify app.
     */
    public suspend fun getBackendEnvironment(input: GetBackendEnvironmentRequest): GetBackendEnvironmentResponse

    /**
     * Returns a branch for an Amplify app.
     */
    public suspend fun getBranch(input: GetBranchRequest): GetBranchResponse

    /**
     * Returns the domain information for an Amplify app.
     */
    public suspend fun getDomainAssociation(input: GetDomainAssociationRequest): GetDomainAssociationResponse

    /**
     * Returns a job for a branch of an Amplify app.
     */
    public suspend fun getJob(input: GetJobRequest): GetJobResponse

    /**
     * Returns the webhook information that corresponds to a specified webhook ID.
     */
    public suspend fun getWebhook(input: GetWebhookRequest): GetWebhookResponse

    /**
     * Returns a list of the existing Amplify apps.
     */
    public suspend fun listApps(input: ListAppsRequest = ListAppsRequest {}): ListAppsResponse

    /**
     * Returns a list of artifacts for a specified app, branch, and job.
     */
    public suspend fun listArtifacts(input: ListArtifactsRequest): ListArtifactsResponse

    /**
     * Lists the backend environments for an Amplify app.
     */
    public suspend fun listBackendEnvironments(input: ListBackendEnvironmentsRequest): ListBackendEnvironmentsResponse

    /**
     * Lists the branches of an Amplify app.
     */
    public suspend fun listBranches(input: ListBranchesRequest): ListBranchesResponse

    /**
     * Returns the domain associations for an Amplify app.
     */
    public suspend fun listDomainAssociations(input: ListDomainAssociationsRequest): ListDomainAssociationsResponse

    /**
     * Lists the jobs for a branch of an Amplify app.
     */
    public suspend fun listJobs(input: ListJobsRequest): ListJobsResponse

    /**
     * Returns a list of tags for a specified Amazon Resource Name (ARN).
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns a list of webhooks for an Amplify app.
     */
    public suspend fun listWebhooks(input: ListWebhooksRequest): ListWebhooksResponse

    /**
     * Starts a deployment for a manually deployed app. Manually deployed apps are not connected to a repository.
     */
    public suspend fun startDeployment(input: StartDeploymentRequest): StartDeploymentResponse

    /**
     * Starts a new job for a branch of an Amplify app.
     */
    public suspend fun startJob(input: StartJobRequest): StartJobResponse

    /**
     * Stops a job that is in progress for a branch of an Amplify app.
     */
    public suspend fun stopJob(input: StopJobRequest): StopJobResponse

    /**
     * Tags the resource with a tag key and value.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Untags a resource with a specified Amazon Resource Name (ARN).
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an existing Amplify app.
     */
    public suspend fun updateApp(input: UpdateAppRequest): UpdateAppResponse

    /**
     * Updates a branch for an Amplify app.
     */
    public suspend fun updateBranch(input: UpdateBranchRequest): UpdateBranchResponse

    /**
     * Creates a new domain association for an Amplify app.
     */
    public suspend fun updateDomainAssociation(input: UpdateDomainAssociationRequest): UpdateDomainAssociationResponse

    /**
     * Updates a webhook.
     */
    public suspend fun updateWebhook(input: UpdateWebhookRequest): UpdateWebhookResponse
}

/**
 * Creates a new Amplify app.
 */
public suspend inline fun AmplifyClient.createApp(crossinline block: CreateAppRequest.Builder.() -> Unit): CreateAppResponse = createApp(CreateAppRequest.Builder().apply(block).build())

/**
 * Creates a new backend environment for an Amplify app.
 */
public suspend inline fun AmplifyClient.createBackendEnvironment(crossinline block: CreateBackendEnvironmentRequest.Builder.() -> Unit): CreateBackendEnvironmentResponse = createBackendEnvironment(CreateBackendEnvironmentRequest.Builder().apply(block).build())

/**
 * Creates a new branch for an Amplify app.
 */
public suspend inline fun AmplifyClient.createBranch(crossinline block: CreateBranchRequest.Builder.() -> Unit): CreateBranchResponse = createBranch(CreateBranchRequest.Builder().apply(block).build())

/**
 * Creates a deployment for a manually deployed Amplify app. Manually deployed apps are not connected to a repository.
 */
public suspend inline fun AmplifyClient.createDeployment(crossinline block: CreateDeploymentRequest.Builder.() -> Unit): CreateDeploymentResponse = createDeployment(CreateDeploymentRequest.Builder().apply(block).build())

/**
 * Creates a new domain association for an Amplify app. This action associates a custom domain with the Amplify app
 */
public suspend inline fun AmplifyClient.createDomainAssociation(crossinline block: CreateDomainAssociationRequest.Builder.() -> Unit): CreateDomainAssociationResponse = createDomainAssociation(CreateDomainAssociationRequest.Builder().apply(block).build())

/**
 * Creates a new webhook on an Amplify app.
 */
public suspend inline fun AmplifyClient.createWebhook(crossinline block: CreateWebhookRequest.Builder.() -> Unit): CreateWebhookResponse = createWebhook(CreateWebhookRequest.Builder().apply(block).build())

/**
 * Deletes an existing Amplify app specified by an app ID.
 */
public suspend inline fun AmplifyClient.deleteApp(crossinline block: DeleteAppRequest.Builder.() -> Unit): DeleteAppResponse = deleteApp(DeleteAppRequest.Builder().apply(block).build())

/**
 * Deletes a backend environment for an Amplify app.
 */
public suspend inline fun AmplifyClient.deleteBackendEnvironment(crossinline block: DeleteBackendEnvironmentRequest.Builder.() -> Unit): DeleteBackendEnvironmentResponse = deleteBackendEnvironment(DeleteBackendEnvironmentRequest.Builder().apply(block).build())

/**
 * Deletes a branch for an Amplify app.
 */
public suspend inline fun AmplifyClient.deleteBranch(crossinline block: DeleteBranchRequest.Builder.() -> Unit): DeleteBranchResponse = deleteBranch(DeleteBranchRequest.Builder().apply(block).build())

/**
 * Deletes a domain association for an Amplify app.
 */
public suspend inline fun AmplifyClient.deleteDomainAssociation(crossinline block: DeleteDomainAssociationRequest.Builder.() -> Unit): DeleteDomainAssociationResponse = deleteDomainAssociation(DeleteDomainAssociationRequest.Builder().apply(block).build())

/**
 * Deletes a job for a branch of an Amplify app.
 */
public suspend inline fun AmplifyClient.deleteJob(crossinline block: DeleteJobRequest.Builder.() -> Unit): DeleteJobResponse = deleteJob(DeleteJobRequest.Builder().apply(block).build())

/**
 * Deletes a webhook.
 */
public suspend inline fun AmplifyClient.deleteWebhook(crossinline block: DeleteWebhookRequest.Builder.() -> Unit): DeleteWebhookResponse = deleteWebhook(DeleteWebhookRequest.Builder().apply(block).build())

/**
 * Returns the website access logs for a specific time range using a presigned URL.
 */
public suspend inline fun AmplifyClient.generateAccessLogs(crossinline block: GenerateAccessLogsRequest.Builder.() -> Unit): GenerateAccessLogsResponse = generateAccessLogs(GenerateAccessLogsRequest.Builder().apply(block).build())

/**
 * Returns an existing Amplify app by appID.
 */
public suspend inline fun AmplifyClient.getApp(crossinline block: GetAppRequest.Builder.() -> Unit): GetAppResponse = getApp(GetAppRequest.Builder().apply(block).build())

/**
 * Returns the artifact info that corresponds to an artifact id.
 */
public suspend inline fun AmplifyClient.getArtifactUrl(crossinline block: GetArtifactUrlRequest.Builder.() -> Unit): GetArtifactUrlResponse = getArtifactUrl(GetArtifactUrlRequest.Builder().apply(block).build())

/**
 * Returns a backend environment for an Amplify app.
 */
public suspend inline fun AmplifyClient.getBackendEnvironment(crossinline block: GetBackendEnvironmentRequest.Builder.() -> Unit): GetBackendEnvironmentResponse = getBackendEnvironment(GetBackendEnvironmentRequest.Builder().apply(block).build())

/**
 * Returns a branch for an Amplify app.
 */
public suspend inline fun AmplifyClient.getBranch(crossinline block: GetBranchRequest.Builder.() -> Unit): GetBranchResponse = getBranch(GetBranchRequest.Builder().apply(block).build())

/**
 * Returns the domain information for an Amplify app.
 */
public suspend inline fun AmplifyClient.getDomainAssociation(crossinline block: GetDomainAssociationRequest.Builder.() -> Unit): GetDomainAssociationResponse = getDomainAssociation(GetDomainAssociationRequest.Builder().apply(block).build())

/**
 * Returns a job for a branch of an Amplify app.
 */
public suspend inline fun AmplifyClient.getJob(crossinline block: GetJobRequest.Builder.() -> Unit): GetJobResponse = getJob(GetJobRequest.Builder().apply(block).build())

/**
 * Returns the webhook information that corresponds to a specified webhook ID.
 */
public suspend inline fun AmplifyClient.getWebhook(crossinline block: GetWebhookRequest.Builder.() -> Unit): GetWebhookResponse = getWebhook(GetWebhookRequest.Builder().apply(block).build())

/**
 * Returns a list of the existing Amplify apps.
 */
public suspend inline fun AmplifyClient.listApps(crossinline block: ListAppsRequest.Builder.() -> Unit): ListAppsResponse = listApps(ListAppsRequest.Builder().apply(block).build())

/**
 * Returns a list of artifacts for a specified app, branch, and job.
 */
public suspend inline fun AmplifyClient.listArtifacts(crossinline block: ListArtifactsRequest.Builder.() -> Unit): ListArtifactsResponse = listArtifacts(ListArtifactsRequest.Builder().apply(block).build())

/**
 * Lists the backend environments for an Amplify app.
 */
public suspend inline fun AmplifyClient.listBackendEnvironments(crossinline block: ListBackendEnvironmentsRequest.Builder.() -> Unit): ListBackendEnvironmentsResponse = listBackendEnvironments(ListBackendEnvironmentsRequest.Builder().apply(block).build())

/**
 * Lists the branches of an Amplify app.
 */
public suspend inline fun AmplifyClient.listBranches(crossinline block: ListBranchesRequest.Builder.() -> Unit): ListBranchesResponse = listBranches(ListBranchesRequest.Builder().apply(block).build())

/**
 * Returns the domain associations for an Amplify app.
 */
public suspend inline fun AmplifyClient.listDomainAssociations(crossinline block: ListDomainAssociationsRequest.Builder.() -> Unit): ListDomainAssociationsResponse = listDomainAssociations(ListDomainAssociationsRequest.Builder().apply(block).build())

/**
 * Lists the jobs for a branch of an Amplify app.
 */
public suspend inline fun AmplifyClient.listJobs(crossinline block: ListJobsRequest.Builder.() -> Unit): ListJobsResponse = listJobs(ListJobsRequest.Builder().apply(block).build())

/**
 * Returns a list of tags for a specified Amazon Resource Name (ARN).
 */
public suspend inline fun AmplifyClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Returns a list of webhooks for an Amplify app.
 */
public suspend inline fun AmplifyClient.listWebhooks(crossinline block: ListWebhooksRequest.Builder.() -> Unit): ListWebhooksResponse = listWebhooks(ListWebhooksRequest.Builder().apply(block).build())

/**
 * Starts a deployment for a manually deployed app. Manually deployed apps are not connected to a repository.
 */
public suspend inline fun AmplifyClient.startDeployment(crossinline block: StartDeploymentRequest.Builder.() -> Unit): StartDeploymentResponse = startDeployment(StartDeploymentRequest.Builder().apply(block).build())

/**
 * Starts a new job for a branch of an Amplify app.
 */
public suspend inline fun AmplifyClient.startJob(crossinline block: StartJobRequest.Builder.() -> Unit): StartJobResponse = startJob(StartJobRequest.Builder().apply(block).build())

/**
 * Stops a job that is in progress for a branch of an Amplify app.
 */
public suspend inline fun AmplifyClient.stopJob(crossinline block: StopJobRequest.Builder.() -> Unit): StopJobResponse = stopJob(StopJobRequest.Builder().apply(block).build())

/**
 * Tags the resource with a tag key and value.
 */
public suspend inline fun AmplifyClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Untags a resource with a specified Amazon Resource Name (ARN).
 */
public suspend inline fun AmplifyClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an existing Amplify app.
 */
public suspend inline fun AmplifyClient.updateApp(crossinline block: UpdateAppRequest.Builder.() -> Unit): UpdateAppResponse = updateApp(UpdateAppRequest.Builder().apply(block).build())

/**
 * Updates a branch for an Amplify app.
 */
public suspend inline fun AmplifyClient.updateBranch(crossinline block: UpdateBranchRequest.Builder.() -> Unit): UpdateBranchResponse = updateBranch(UpdateBranchRequest.Builder().apply(block).build())

/**
 * Creates a new domain association for an Amplify app.
 */
public suspend inline fun AmplifyClient.updateDomainAssociation(crossinline block: UpdateDomainAssociationRequest.Builder.() -> Unit): UpdateDomainAssociationResponse = updateDomainAssociation(UpdateDomainAssociationRequest.Builder().apply(block).build())

/**
 * Updates a webhook.
 */
public suspend inline fun AmplifyClient.updateWebhook(crossinline block: UpdateWebhookRequest.Builder.() -> Unit): UpdateWebhookResponse = updateWebhook(UpdateWebhookRequest.Builder().apply(block).build())
