// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the cache configuration for an Amplify app.
 *
 * For more information about how Amplify applies an optimal cache configuration for your app based on the type of content that is being served, see [Managing cache configuration](https://docs.aws.amazon.com/amplify/latest/userguide/managing-cache-configuration) in the *Amplify User guide*.
 */
public class CacheConfig private constructor(builder: Builder) {
    /**
     * The type of cache configuration to use for an Amplify app.
     *
     * The `AMPLIFY_MANAGED` cache configuration automatically applies an optimized cache configuration for your app based on its platform, routing rules, and rewrite rules.
     *
     * The `AMPLIFY_MANAGED_NO_COOKIES` cache configuration type is the same as `AMPLIFY_MANAGED`, except that it excludes all cookies from the cache key. This is the default setting.
     */
    public val type: aws.sdk.kotlin.services.amplify.model.CacheConfigType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.CacheConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CacheConfig(")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = type.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CacheConfig

        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.CacheConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of cache configuration to use for an Amplify app.
         *
         * The `AMPLIFY_MANAGED` cache configuration automatically applies an optimized cache configuration for your app based on its platform, routing rules, and rewrite rules.
         *
         * The `AMPLIFY_MANAGED_NO_COOKIES` cache configuration type is the same as `AMPLIFY_MANAGED`, except that it excludes all cookies from the cache key. This is the default setting.
         */
        public var type: aws.sdk.kotlin.services.amplify.model.CacheConfigType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.CacheConfig) : this() {
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.CacheConfig = CacheConfig(this)

        internal fun correctErrors(): Builder {
            if (type == null) type = CacheConfigType.SdkUnknown("no value provided")
            return this
        }
    }
}
