// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the Firewall configuration for a hosted Amplify application. Firewall support enables you to protect your web applications with a direct integration with WAF. For more information about using WAF protections for an Amplify application, see [Firewall support for hosted sites](https://docs.aws.amazon.com/amplify/latest/userguide/WAF-integration.html) in the *Amplify User Guide*.
 */
public class WafConfiguration private constructor(builder: Builder) {
    /**
     * The reason for the current status of the Firewall configuration.
     */
    public val statusReason: kotlin.String? = builder.statusReason
    /**
     * The status of the process to associate or disassociate a web ACL to an Amplify app.
     */
    public val wafStatus: aws.sdk.kotlin.services.amplify.model.WafStatus? = builder.wafStatus
    /**
     * The Amazon Resource Name (ARN) for the web ACL associated with an Amplify app.
     */
    public val webAclArn: kotlin.String? = builder.webAclArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.WafConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WafConfiguration(")
        append("statusReason=$statusReason,")
        append("wafStatus=$wafStatus,")
        append("webAclArn=$webAclArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = statusReason?.hashCode() ?: 0
        result = 31 * result + (wafStatus?.hashCode() ?: 0)
        result = 31 * result + (webAclArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WafConfiguration

        if (statusReason != other.statusReason) return false
        if (wafStatus != other.wafStatus) return false
        if (webAclArn != other.webAclArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.WafConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The reason for the current status of the Firewall configuration.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The status of the process to associate or disassociate a web ACL to an Amplify app.
         */
        public var wafStatus: aws.sdk.kotlin.services.amplify.model.WafStatus? = null
        /**
         * The Amazon Resource Name (ARN) for the web ACL associated with an Amplify app.
         */
        public var webAclArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.WafConfiguration) : this() {
            this.statusReason = x.statusReason
            this.wafStatus = x.wafStatus
            this.webAclArn = x.webAclArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.WafConfiguration = WafConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
