// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * The branch for an Amplify app, which maps to a third-party repository branch.
 */
public class Branch private constructor(builder: Builder) {
    /**
     * The ID of the active job for a branch of an Amplify app.
     */
    public val activeJobId: kotlin.String = requireNotNull(builder.activeJobId) { "A non-null value must be provided for activeJobId" }
    /**
     * A list of custom resources that are linked to this branch.
     */
    public val associatedResources: List<String>? = builder.associatedResources
    /**
     * Describes the backend associated with an Amplify `Branch`.
     *
     * This property is available to Amplify Gen 2 apps only. When you deploy an application with Amplify Gen 2, you provision the app's backend infrastructure using Typescript code.
     */
    public val backend: aws.sdk.kotlin.services.amplify.model.Backend? = builder.backend
    /**
     * The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app.
     *
     * This property is available to Amplify Gen 1 apps only. When you deploy an application with Amplify Gen 2, you provision the app's backend infrastructure using Typescript code.
     */
    public val backendEnvironmentArn: kotlin.String? = builder.backendEnvironmentArn
    /**
     * The basic authorization credentials for a branch of an Amplify app. You must base64-encode the authorization credentials and provide them in the format `user:password`.
     */
    public val basicAuthCredentials: kotlin.String? = builder.basicAuthCredentials
    /**
     * The Amazon Resource Name (ARN) for a branch that is part of an Amplify app.
     */
    public val branchArn: kotlin.String = requireNotNull(builder.branchArn) { "A non-null value must be provided for branchArn" }
    /**
     * The name for the branch that is part of an Amplify app.
     */
    public val branchName: kotlin.String = requireNotNull(builder.branchName) { "A non-null value must be provided for branchName" }
    /**
     * The build specification (build spec) content for the branch of an Amplify app.
     */
    public val buildSpec: kotlin.String? = builder.buildSpec
    /**
     * The Amazon Resource Name (ARN) of the IAM role for a branch of an SSR app. The Compute role allows the Amplify Hosting compute service to securely access specific Amazon Web Services resources based on the role's permissions. For more information about the SSR Compute role, see [Adding an SSR Compute role](https://docs.aws.amazon.com/amplify/latest/userguide/amplify-SSR-compute-role.html) in the *Amplify User Guide*.
     */
    public val computeRoleArn: kotlin.String? = builder.computeRoleArn
    /**
     * A timestamp of when Amplify created the branch.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * The custom domains for a branch of an Amplify app.
     */
    public val customDomains: List<String> = requireNotNull(builder.customDomains) { "A non-null value must be provided for customDomains" }
    /**
     * The description for the branch that is part of an Amplify app.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * The destination branch if the branch is a pull request branch.
     */
    public val destinationBranch: kotlin.String? = builder.destinationBranch
    /**
     * The display name for the branch. This is used as the default domain prefix.
     */
    public val displayName: kotlin.String = requireNotNull(builder.displayName) { "A non-null value must be provided for displayName" }
    /**
     * Enables auto-building on push for a branch of an Amplify app.
     */
    public val enableAutoBuild: kotlin.Boolean = requireNotNull(builder.enableAutoBuild) { "A non-null value must be provided for enableAutoBuild" }
    /**
     * Enables basic authorization for a branch of an Amplify app.
     */
    public val enableBasicAuth: kotlin.Boolean = requireNotNull(builder.enableBasicAuth) { "A non-null value must be provided for enableBasicAuth" }
    /**
     * Enables notifications for a branch that is part of an Amplify app.
     */
    public val enableNotification: kotlin.Boolean = requireNotNull(builder.enableNotification) { "A non-null value must be provided for enableNotification" }
    /**
     * Enables performance mode for the branch.
     *
     * Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out.
     */
    public val enablePerformanceMode: kotlin.Boolean? = builder.enablePerformanceMode
    /**
     * Enables pull request previews for the branch.
     */
    public val enablePullRequestPreview: kotlin.Boolean = requireNotNull(builder.enablePullRequestPreview) { "A non-null value must be provided for enablePullRequestPreview" }
    /**
     * Specifies whether the skew protection feature is enabled for the branch.
     *
     * Deployment skew protection is available to Amplify applications to eliminate version skew issues between client and servers in web applications. When you apply skew protection to a branch, you can ensure that your clients always interact with the correct version of server-side assets, regardless of when a deployment occurs. For more information about skew protection, see [Skew protection for Amplify deployments](https://docs.aws.amazon.com/amplify/latest/userguide/skew-protection.html) in the *Amplify User Guide*.
     */
    public val enableSkewProtection: kotlin.Boolean? = builder.enableSkewProtection
    /**
     * The environment variables specific to a branch of an Amplify app.
     */
    public val environmentVariables: Map<String, String> = requireNotNull(builder.environmentVariables) { "A non-null value must be provided for environmentVariables" }
    /**
     * The framework for a branch of an Amplify app.
     */
    public val framework: kotlin.String = requireNotNull(builder.framework) { "A non-null value must be provided for framework" }
    /**
     * The Amplify environment name for the pull request.
     */
    public val pullRequestEnvironmentName: kotlin.String? = builder.pullRequestEnvironmentName
    /**
     * The source branch if the branch is a pull request branch.
     */
    public val sourceBranch: kotlin.String? = builder.sourceBranch
    /**
     * The current stage for the branch that is part of an Amplify app.
     */
    public val stage: aws.sdk.kotlin.services.amplify.model.Stage = requireNotNull(builder.stage) { "A non-null value must be provided for stage" }
    /**
     * The tag for the branch of an Amplify app.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The thumbnail URL for the branch of an Amplify app.
     */
    public val thumbnailUrl: kotlin.String? = builder.thumbnailUrl
    /**
     * The total number of jobs that are part of an Amplify app.
     */
    public val totalNumberOfJobs: kotlin.String = requireNotNull(builder.totalNumberOfJobs) { "A non-null value must be provided for totalNumberOfJobs" }
    /**
     * The content Time to Live (TTL) for the website in seconds.
     */
    public val ttl: kotlin.String = requireNotNull(builder.ttl) { "A non-null value must be provided for ttl" }
    /**
     * A timestamp for the last updated time for a branch.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.Branch = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Branch(")
        append("activeJobId=$activeJobId,")
        append("associatedResources=$associatedResources,")
        append("backend=$backend,")
        append("backendEnvironmentArn=$backendEnvironmentArn,")
        append("basicAuthCredentials=*** Sensitive Data Redacted ***,")
        append("branchArn=$branchArn,")
        append("branchName=$branchName,")
        append("buildSpec=*** Sensitive Data Redacted ***,")
        append("computeRoleArn=$computeRoleArn,")
        append("createTime=$createTime,")
        append("customDomains=$customDomains,")
        append("description=$description,")
        append("destinationBranch=$destinationBranch,")
        append("displayName=$displayName,")
        append("enableAutoBuild=$enableAutoBuild,")
        append("enableBasicAuth=$enableBasicAuth,")
        append("enableNotification=$enableNotification,")
        append("enablePerformanceMode=$enablePerformanceMode,")
        append("enablePullRequestPreview=$enablePullRequestPreview,")
        append("enableSkewProtection=$enableSkewProtection,")
        append("environmentVariables=$environmentVariables,")
        append("framework=$framework,")
        append("pullRequestEnvironmentName=$pullRequestEnvironmentName,")
        append("sourceBranch=$sourceBranch,")
        append("stage=$stage,")
        append("tags=$tags,")
        append("thumbnailUrl=$thumbnailUrl,")
        append("totalNumberOfJobs=$totalNumberOfJobs,")
        append("ttl=$ttl,")
        append("updateTime=$updateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = activeJobId.hashCode()
        result = 31 * result + (associatedResources?.hashCode() ?: 0)
        result = 31 * result + (backend?.hashCode() ?: 0)
        result = 31 * result + (backendEnvironmentArn?.hashCode() ?: 0)
        result = 31 * result + (basicAuthCredentials?.hashCode() ?: 0)
        result = 31 * result + (branchArn.hashCode())
        result = 31 * result + (branchName.hashCode())
        result = 31 * result + (buildSpec?.hashCode() ?: 0)
        result = 31 * result + (computeRoleArn?.hashCode() ?: 0)
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (customDomains.hashCode())
        result = 31 * result + (description.hashCode())
        result = 31 * result + (destinationBranch?.hashCode() ?: 0)
        result = 31 * result + (displayName.hashCode())
        result = 31 * result + (enableAutoBuild.hashCode())
        result = 31 * result + (enableBasicAuth.hashCode())
        result = 31 * result + (enableNotification.hashCode())
        result = 31 * result + (enablePerformanceMode?.hashCode() ?: 0)
        result = 31 * result + (enablePullRequestPreview.hashCode())
        result = 31 * result + (enableSkewProtection?.hashCode() ?: 0)
        result = 31 * result + (environmentVariables.hashCode())
        result = 31 * result + (framework.hashCode())
        result = 31 * result + (pullRequestEnvironmentName?.hashCode() ?: 0)
        result = 31 * result + (sourceBranch?.hashCode() ?: 0)
        result = 31 * result + (stage.hashCode())
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (thumbnailUrl?.hashCode() ?: 0)
        result = 31 * result + (totalNumberOfJobs.hashCode())
        result = 31 * result + (ttl.hashCode())
        result = 31 * result + (updateTime.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Branch

        if (activeJobId != other.activeJobId) return false
        if (associatedResources != other.associatedResources) return false
        if (backend != other.backend) return false
        if (backendEnvironmentArn != other.backendEnvironmentArn) return false
        if (basicAuthCredentials != other.basicAuthCredentials) return false
        if (branchArn != other.branchArn) return false
        if (branchName != other.branchName) return false
        if (buildSpec != other.buildSpec) return false
        if (computeRoleArn != other.computeRoleArn) return false
        if (createTime != other.createTime) return false
        if (customDomains != other.customDomains) return false
        if (description != other.description) return false
        if (destinationBranch != other.destinationBranch) return false
        if (displayName != other.displayName) return false
        if (enableAutoBuild != other.enableAutoBuild) return false
        if (enableBasicAuth != other.enableBasicAuth) return false
        if (enableNotification != other.enableNotification) return false
        if (enablePerformanceMode != other.enablePerformanceMode) return false
        if (enablePullRequestPreview != other.enablePullRequestPreview) return false
        if (enableSkewProtection != other.enableSkewProtection) return false
        if (environmentVariables != other.environmentVariables) return false
        if (framework != other.framework) return false
        if (pullRequestEnvironmentName != other.pullRequestEnvironmentName) return false
        if (sourceBranch != other.sourceBranch) return false
        if (stage != other.stage) return false
        if (tags != other.tags) return false
        if (thumbnailUrl != other.thumbnailUrl) return false
        if (totalNumberOfJobs != other.totalNumberOfJobs) return false
        if (ttl != other.ttl) return false
        if (updateTime != other.updateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.Branch = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ID of the active job for a branch of an Amplify app.
         */
        public var activeJobId: kotlin.String? = null
        /**
         * A list of custom resources that are linked to this branch.
         */
        public var associatedResources: List<String>? = null
        /**
         * Describes the backend associated with an Amplify `Branch`.
         *
         * This property is available to Amplify Gen 2 apps only. When you deploy an application with Amplify Gen 2, you provision the app's backend infrastructure using Typescript code.
         */
        public var backend: aws.sdk.kotlin.services.amplify.model.Backend? = null
        /**
         * The Amazon Resource Name (ARN) for a backend environment that is part of an Amplify app.
         *
         * This property is available to Amplify Gen 1 apps only. When you deploy an application with Amplify Gen 2, you provision the app's backend infrastructure using Typescript code.
         */
        public var backendEnvironmentArn: kotlin.String? = null
        /**
         * The basic authorization credentials for a branch of an Amplify app. You must base64-encode the authorization credentials and provide them in the format `user:password`.
         */
        public var basicAuthCredentials: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for a branch that is part of an Amplify app.
         */
        public var branchArn: kotlin.String? = null
        /**
         * The name for the branch that is part of an Amplify app.
         */
        public var branchName: kotlin.String? = null
        /**
         * The build specification (build spec) content for the branch of an Amplify app.
         */
        public var buildSpec: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role for a branch of an SSR app. The Compute role allows the Amplify Hosting compute service to securely access specific Amazon Web Services resources based on the role's permissions. For more information about the SSR Compute role, see [Adding an SSR Compute role](https://docs.aws.amazon.com/amplify/latest/userguide/amplify-SSR-compute-role.html) in the *Amplify User Guide*.
         */
        public var computeRoleArn: kotlin.String? = null
        /**
         * A timestamp of when Amplify created the branch.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The custom domains for a branch of an Amplify app.
         */
        public var customDomains: List<String>? = null
        /**
         * The description for the branch that is part of an Amplify app.
         */
        public var description: kotlin.String? = null
        /**
         * The destination branch if the branch is a pull request branch.
         */
        public var destinationBranch: kotlin.String? = null
        /**
         * The display name for the branch. This is used as the default domain prefix.
         */
        public var displayName: kotlin.String? = null
        /**
         * Enables auto-building on push for a branch of an Amplify app.
         */
        public var enableAutoBuild: kotlin.Boolean? = null
        /**
         * Enables basic authorization for a branch of an Amplify app.
         */
        public var enableBasicAuth: kotlin.Boolean? = null
        /**
         * Enables notifications for a branch that is part of an Amplify app.
         */
        public var enableNotification: kotlin.Boolean? = null
        /**
         * Enables performance mode for the branch.
         *
         * Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out.
         */
        public var enablePerformanceMode: kotlin.Boolean? = null
        /**
         * Enables pull request previews for the branch.
         */
        public var enablePullRequestPreview: kotlin.Boolean? = null
        /**
         * Specifies whether the skew protection feature is enabled for the branch.
         *
         * Deployment skew protection is available to Amplify applications to eliminate version skew issues between client and servers in web applications. When you apply skew protection to a branch, you can ensure that your clients always interact with the correct version of server-side assets, regardless of when a deployment occurs. For more information about skew protection, see [Skew protection for Amplify deployments](https://docs.aws.amazon.com/amplify/latest/userguide/skew-protection.html) in the *Amplify User Guide*.
         */
        public var enableSkewProtection: kotlin.Boolean? = null
        /**
         * The environment variables specific to a branch of an Amplify app.
         */
        public var environmentVariables: Map<String, String>? = null
        /**
         * The framework for a branch of an Amplify app.
         */
        public var framework: kotlin.String? = null
        /**
         * The Amplify environment name for the pull request.
         */
        public var pullRequestEnvironmentName: kotlin.String? = null
        /**
         * The source branch if the branch is a pull request branch.
         */
        public var sourceBranch: kotlin.String? = null
        /**
         * The current stage for the branch that is part of an Amplify app.
         */
        public var stage: aws.sdk.kotlin.services.amplify.model.Stage? = null
        /**
         * The tag for the branch of an Amplify app.
         */
        public var tags: Map<String, String>? = null
        /**
         * The thumbnail URL for the branch of an Amplify app.
         */
        public var thumbnailUrl: kotlin.String? = null
        /**
         * The total number of jobs that are part of an Amplify app.
         */
        public var totalNumberOfJobs: kotlin.String? = null
        /**
         * The content Time to Live (TTL) for the website in seconds.
         */
        public var ttl: kotlin.String? = null
        /**
         * A timestamp for the last updated time for a branch.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.Branch) : this() {
            this.activeJobId = x.activeJobId
            this.associatedResources = x.associatedResources
            this.backend = x.backend
            this.backendEnvironmentArn = x.backendEnvironmentArn
            this.basicAuthCredentials = x.basicAuthCredentials
            this.branchArn = x.branchArn
            this.branchName = x.branchName
            this.buildSpec = x.buildSpec
            this.computeRoleArn = x.computeRoleArn
            this.createTime = x.createTime
            this.customDomains = x.customDomains
            this.description = x.description
            this.destinationBranch = x.destinationBranch
            this.displayName = x.displayName
            this.enableAutoBuild = x.enableAutoBuild
            this.enableBasicAuth = x.enableBasicAuth
            this.enableNotification = x.enableNotification
            this.enablePerformanceMode = x.enablePerformanceMode
            this.enablePullRequestPreview = x.enablePullRequestPreview
            this.enableSkewProtection = x.enableSkewProtection
            this.environmentVariables = x.environmentVariables
            this.framework = x.framework
            this.pullRequestEnvironmentName = x.pullRequestEnvironmentName
            this.sourceBranch = x.sourceBranch
            this.stage = x.stage
            this.tags = x.tags
            this.thumbnailUrl = x.thumbnailUrl
            this.totalNumberOfJobs = x.totalNumberOfJobs
            this.ttl = x.ttl
            this.updateTime = x.updateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.Branch = Branch(this)

        /**
         * construct an [aws.sdk.kotlin.services.amplify.model.Backend] inside the given [block]
         */
        public fun backend(block: aws.sdk.kotlin.services.amplify.model.Backend.Builder.() -> kotlin.Unit) {
            this.backend = aws.sdk.kotlin.services.amplify.model.Backend.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (activeJobId == null) activeJobId = ""
            if (branchArn == null) branchArn = ""
            if (branchName == null) branchName = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (customDomains == null) customDomains = emptyList()
            if (description == null) description = ""
            if (displayName == null) displayName = ""
            if (enableAutoBuild == null) enableAutoBuild = false
            if (enableBasicAuth == null) enableBasicAuth = false
            if (enableNotification == null) enableNotification = false
            if (enablePullRequestPreview == null) enablePullRequestPreview = false
            if (environmentVariables == null) environmentVariables = emptyMap()
            if (framework == null) framework = ""
            if (stage == null) stage = Stage.SdkUnknown("no value provided")
            if (totalNumberOfJobs == null) totalNumberOfJobs = ""
            if (ttl == null) ttl = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
