// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the association between a custom domain and an Amplify app.
 */
public class DomainAssociation private constructor(builder: Builder) {
    /**
     * Sets branch patterns for automatic subdomain creation.
     */
    public val autoSubDomainCreationPatterns: List<String>? = builder.autoSubDomainCreationPatterns
    /**
     * The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains.
     */
    public val autoSubDomainIamRole: kotlin.String? = builder.autoSubDomainIamRole
    /**
     * Describes the SSL/TLS certificate for the domain association. This can be your own custom certificate or the default certificate that Amplify provisions for you.
     *
     * If you are updating your domain to use a different certificate, `certificate` points to the new certificate that is being created instead of the current active certificate. Otherwise, `certificate` points to the current active certificate.
     */
    public val certificate: aws.sdk.kotlin.services.amplify.model.Certificate? = builder.certificate
    /**
     * The DNS record for certificate verification.
     */
    public val certificateVerificationDnsRecord: kotlin.String? = builder.certificateVerificationDnsRecord
    /**
     * The Amazon Resource Name (ARN) for the domain association.
     */
    public val domainAssociationArn: kotlin.String = requireNotNull(builder.domainAssociationArn) { "A non-null value must be provided for domainAssociationArn" }
    /**
     * The name of the domain.
     */
    public val domainName: kotlin.String = requireNotNull(builder.domainName) { "A non-null value must be provided for domainName" }
    /**
     * The current status of the domain association.
     */
    public val domainStatus: aws.sdk.kotlin.services.amplify.model.DomainStatus = requireNotNull(builder.domainStatus) { "A non-null value must be provided for domainStatus" }
    /**
     * Enables the automated creation of subdomains for branches.
     */
    public val enableAutoSubDomain: kotlin.Boolean = requireNotNull(builder.enableAutoSubDomain) { "A non-null value must be provided for enableAutoSubDomain" }
    /**
     * Additional information that describes why the domain association is in the current state.
     */
    public val statusReason: kotlin.String = requireNotNull(builder.statusReason) { "A non-null value must be provided for statusReason" }
    /**
     * The subdomains for the domain association.
     */
    public val subDomains: List<SubDomain> = requireNotNull(builder.subDomains) { "A non-null value must be provided for subDomains" }
    /**
     * The status of the domain update operation that is currently in progress. The following list describes the valid update states.
     *
     * ## REQUESTING_CERTIFICATE
     * The certificate is in the process of being updated.
     *
     * ## PENDING_VERIFICATION
     * Indicates that an Amplify managed certificate is in the process of being verified. This occurs during the creation of a custom domain or when a custom domain is updated to use a managed certificate.
     *
     * ## IMPORTING_CUSTOM_CERTIFICATE
     * Indicates that an Amplify custom certificate is in the process of being imported. This occurs during the creation of a custom domain or when a custom domain is updated to use a custom certificate.
     *
     * ## PENDING_DEPLOYMENT
     * Indicates that the subdomain or certificate changes are being propagated.
     *
     * ## AWAITING_APP_CNAME
     * Amplify is waiting for CNAME records corresponding to subdomains to be propagated. If your custom domain is on Route 53, Amplify handles this for you automatically. For more information about custom domains, see [Setting up custom domains](https://docs.aws.amazon.com/amplify/latest/userguide/custom-domains.html) in the *Amplify Hosting User Guide*.
     *
     * ## UPDATE_COMPLETE
     * The certificate has been associated with a domain.
     *
     * ## UPDATE_FAILED
     * The certificate has failed to be provisioned or associated, and there is no existing active certificate to roll back to.
     */
    public val updateStatus: aws.sdk.kotlin.services.amplify.model.UpdateStatus? = builder.updateStatus

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.DomainAssociation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DomainAssociation(")
        append("autoSubDomainCreationPatterns=$autoSubDomainCreationPatterns,")
        append("autoSubDomainIamRole=$autoSubDomainIamRole,")
        append("certificate=$certificate,")
        append("certificateVerificationDnsRecord=$certificateVerificationDnsRecord,")
        append("domainAssociationArn=$domainAssociationArn,")
        append("domainName=$domainName,")
        append("domainStatus=$domainStatus,")
        append("enableAutoSubDomain=$enableAutoSubDomain,")
        append("statusReason=$statusReason,")
        append("subDomains=$subDomains,")
        append("updateStatus=$updateStatus")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = autoSubDomainCreationPatterns?.hashCode() ?: 0
        result = 31 * result + (autoSubDomainIamRole?.hashCode() ?: 0)
        result = 31 * result + (certificate?.hashCode() ?: 0)
        result = 31 * result + (certificateVerificationDnsRecord?.hashCode() ?: 0)
        result = 31 * result + (domainAssociationArn.hashCode())
        result = 31 * result + (domainName.hashCode())
        result = 31 * result + (domainStatus.hashCode())
        result = 31 * result + (enableAutoSubDomain.hashCode())
        result = 31 * result + (statusReason.hashCode())
        result = 31 * result + (subDomains.hashCode())
        result = 31 * result + (updateStatus?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DomainAssociation

        if (autoSubDomainCreationPatterns != other.autoSubDomainCreationPatterns) return false
        if (autoSubDomainIamRole != other.autoSubDomainIamRole) return false
        if (certificate != other.certificate) return false
        if (certificateVerificationDnsRecord != other.certificateVerificationDnsRecord) return false
        if (domainAssociationArn != other.domainAssociationArn) return false
        if (domainName != other.domainName) return false
        if (domainStatus != other.domainStatus) return false
        if (enableAutoSubDomain != other.enableAutoSubDomain) return false
        if (statusReason != other.statusReason) return false
        if (subDomains != other.subDomains) return false
        if (updateStatus != other.updateStatus) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.DomainAssociation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Sets branch patterns for automatic subdomain creation.
         */
        public var autoSubDomainCreationPatterns: List<String>? = null
        /**
         * The required AWS Identity and Access Management (IAM) service role for the Amazon Resource Name (ARN) for automatically creating subdomains.
         */
        public var autoSubDomainIamRole: kotlin.String? = null
        /**
         * Describes the SSL/TLS certificate for the domain association. This can be your own custom certificate or the default certificate that Amplify provisions for you.
         *
         * If you are updating your domain to use a different certificate, `certificate` points to the new certificate that is being created instead of the current active certificate. Otherwise, `certificate` points to the current active certificate.
         */
        public var certificate: aws.sdk.kotlin.services.amplify.model.Certificate? = null
        /**
         * The DNS record for certificate verification.
         */
        public var certificateVerificationDnsRecord: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) for the domain association.
         */
        public var domainAssociationArn: kotlin.String? = null
        /**
         * The name of the domain.
         */
        public var domainName: kotlin.String? = null
        /**
         * The current status of the domain association.
         */
        public var domainStatus: aws.sdk.kotlin.services.amplify.model.DomainStatus? = null
        /**
         * Enables the automated creation of subdomains for branches.
         */
        public var enableAutoSubDomain: kotlin.Boolean? = null
        /**
         * Additional information that describes why the domain association is in the current state.
         */
        public var statusReason: kotlin.String? = null
        /**
         * The subdomains for the domain association.
         */
        public var subDomains: List<SubDomain>? = null
        /**
         * The status of the domain update operation that is currently in progress. The following list describes the valid update states.
         *
         * ## REQUESTING_CERTIFICATE
         * The certificate is in the process of being updated.
         *
         * ## PENDING_VERIFICATION
         * Indicates that an Amplify managed certificate is in the process of being verified. This occurs during the creation of a custom domain or when a custom domain is updated to use a managed certificate.
         *
         * ## IMPORTING_CUSTOM_CERTIFICATE
         * Indicates that an Amplify custom certificate is in the process of being imported. This occurs during the creation of a custom domain or when a custom domain is updated to use a custom certificate.
         *
         * ## PENDING_DEPLOYMENT
         * Indicates that the subdomain or certificate changes are being propagated.
         *
         * ## AWAITING_APP_CNAME
         * Amplify is waiting for CNAME records corresponding to subdomains to be propagated. If your custom domain is on Route 53, Amplify handles this for you automatically. For more information about custom domains, see [Setting up custom domains](https://docs.aws.amazon.com/amplify/latest/userguide/custom-domains.html) in the *Amplify Hosting User Guide*.
         *
         * ## UPDATE_COMPLETE
         * The certificate has been associated with a domain.
         *
         * ## UPDATE_FAILED
         * The certificate has failed to be provisioned or associated, and there is no existing active certificate to roll back to.
         */
        public var updateStatus: aws.sdk.kotlin.services.amplify.model.UpdateStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.DomainAssociation) : this() {
            this.autoSubDomainCreationPatterns = x.autoSubDomainCreationPatterns
            this.autoSubDomainIamRole = x.autoSubDomainIamRole
            this.certificate = x.certificate
            this.certificateVerificationDnsRecord = x.certificateVerificationDnsRecord
            this.domainAssociationArn = x.domainAssociationArn
            this.domainName = x.domainName
            this.domainStatus = x.domainStatus
            this.enableAutoSubDomain = x.enableAutoSubDomain
            this.statusReason = x.statusReason
            this.subDomains = x.subDomains
            this.updateStatus = x.updateStatus
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.DomainAssociation = DomainAssociation(this)

        /**
         * construct an [aws.sdk.kotlin.services.amplify.model.Certificate] inside the given [block]
         */
        public fun certificate(block: aws.sdk.kotlin.services.amplify.model.Certificate.Builder.() -> kotlin.Unit) {
            this.certificate = aws.sdk.kotlin.services.amplify.model.Certificate.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (domainAssociationArn == null) domainAssociationArn = ""
            if (domainName == null) domainName = ""
            if (domainStatus == null) domainStatus = DomainStatus.SdkUnknown("no value provided")
            if (enableAutoSubDomain == null) enableAutoSubDomain = false
            if (statusReason == null) statusReason = ""
            if (subDomains == null) subDomains = emptyList()
            return this
        }
    }
}
