// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the automated branch creation configuration.
 */
public class AutoBranchCreationConfig private constructor(builder: Builder) {
    /**
     * The basic authorization credentials for the autocreated branch. You must base64-encode the authorization credentials and provide them in the format `user:password`.
     */
    public val basicAuthCredentials: kotlin.String? = builder.basicAuthCredentials
    /**
     * The build specification (build spec) for the autocreated branch.
     */
    public val buildSpec: kotlin.String? = builder.buildSpec
    /**
     * Enables auto building for the autocreated branch.
     */
    public val enableAutoBuild: kotlin.Boolean? = builder.enableAutoBuild
    /**
     * Enables basic authorization for the autocreated branch.
     */
    public val enableBasicAuth: kotlin.Boolean? = builder.enableBasicAuth
    /**
     * Enables performance mode for the branch.
     *
     * Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out.
     */
    public val enablePerformanceMode: kotlin.Boolean? = builder.enablePerformanceMode
    /**
     * Enables pull request previews for the autocreated branch.
     */
    public val enablePullRequestPreview: kotlin.Boolean? = builder.enablePullRequestPreview
    /**
     * The environment variables for the autocreated branch.
     */
    public val environmentVariables: Map<String, String>? = builder.environmentVariables
    /**
     * The framework for the autocreated branch.
     */
    public val framework: kotlin.String? = builder.framework
    /**
     * The Amplify environment name for the pull request.
     */
    public val pullRequestEnvironmentName: kotlin.String? = builder.pullRequestEnvironmentName
    /**
     * Describes the current stage for the autocreated branch.
     */
    public val stage: aws.sdk.kotlin.services.amplify.model.Stage? = builder.stage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.AutoBranchCreationConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AutoBranchCreationConfig(")
        append("basicAuthCredentials=*** Sensitive Data Redacted ***,")
        append("buildSpec=*** Sensitive Data Redacted ***,")
        append("enableAutoBuild=$enableAutoBuild,")
        append("enableBasicAuth=$enableBasicAuth,")
        append("enablePerformanceMode=$enablePerformanceMode,")
        append("enablePullRequestPreview=$enablePullRequestPreview,")
        append("environmentVariables=$environmentVariables,")
        append("framework=$framework,")
        append("pullRequestEnvironmentName=$pullRequestEnvironmentName,")
        append("stage=$stage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = basicAuthCredentials?.hashCode() ?: 0
        result = 31 * result + (buildSpec?.hashCode() ?: 0)
        result = 31 * result + (enableAutoBuild?.hashCode() ?: 0)
        result = 31 * result + (enableBasicAuth?.hashCode() ?: 0)
        result = 31 * result + (enablePerformanceMode?.hashCode() ?: 0)
        result = 31 * result + (enablePullRequestPreview?.hashCode() ?: 0)
        result = 31 * result + (environmentVariables?.hashCode() ?: 0)
        result = 31 * result + (framework?.hashCode() ?: 0)
        result = 31 * result + (pullRequestEnvironmentName?.hashCode() ?: 0)
        result = 31 * result + (stage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AutoBranchCreationConfig

        if (basicAuthCredentials != other.basicAuthCredentials) return false
        if (buildSpec != other.buildSpec) return false
        if (enableAutoBuild != other.enableAutoBuild) return false
        if (enableBasicAuth != other.enableBasicAuth) return false
        if (enablePerformanceMode != other.enablePerformanceMode) return false
        if (enablePullRequestPreview != other.enablePullRequestPreview) return false
        if (environmentVariables != other.environmentVariables) return false
        if (framework != other.framework) return false
        if (pullRequestEnvironmentName != other.pullRequestEnvironmentName) return false
        if (stage != other.stage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.AutoBranchCreationConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The basic authorization credentials for the autocreated branch. You must base64-encode the authorization credentials and provide them in the format `user:password`.
         */
        public var basicAuthCredentials: kotlin.String? = null
        /**
         * The build specification (build spec) for the autocreated branch.
         */
        public var buildSpec: kotlin.String? = null
        /**
         * Enables auto building for the autocreated branch.
         */
        public var enableAutoBuild: kotlin.Boolean? = null
        /**
         * Enables basic authorization for the autocreated branch.
         */
        public var enableBasicAuth: kotlin.Boolean? = null
        /**
         * Enables performance mode for the branch.
         *
         * Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out.
         */
        public var enablePerformanceMode: kotlin.Boolean? = null
        /**
         * Enables pull request previews for the autocreated branch.
         */
        public var enablePullRequestPreview: kotlin.Boolean? = null
        /**
         * The environment variables for the autocreated branch.
         */
        public var environmentVariables: Map<String, String>? = null
        /**
         * The framework for the autocreated branch.
         */
        public var framework: kotlin.String? = null
        /**
         * The Amplify environment name for the pull request.
         */
        public var pullRequestEnvironmentName: kotlin.String? = null
        /**
         * Describes the current stage for the autocreated branch.
         */
        public var stage: aws.sdk.kotlin.services.amplify.model.Stage? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.AutoBranchCreationConfig) : this() {
            this.basicAuthCredentials = x.basicAuthCredentials
            this.buildSpec = x.buildSpec
            this.enableAutoBuild = x.enableAutoBuild
            this.enableBasicAuth = x.enableBasicAuth
            this.enablePerformanceMode = x.enablePerformanceMode
            this.enablePullRequestPreview = x.enablePullRequestPreview
            this.environmentVariables = x.environmentVariables
            this.framework = x.framework
            this.pullRequestEnvironmentName = x.pullRequestEnvironmentName
            this.stage = x.stage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.AutoBranchCreationConfig = AutoBranchCreationConfig(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
