// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.paginators

import aws.sdk.kotlin.services.amplify.AmplifyClient
import aws.sdk.kotlin.services.amplify.model.App
import aws.sdk.kotlin.services.amplify.model.Branch
import aws.sdk.kotlin.services.amplify.model.DomainAssociation
import aws.sdk.kotlin.services.amplify.model.JobSummary
import aws.sdk.kotlin.services.amplify.model.ListAppsRequest
import aws.sdk.kotlin.services.amplify.model.ListAppsResponse
import aws.sdk.kotlin.services.amplify.model.ListBranchesRequest
import aws.sdk.kotlin.services.amplify.model.ListBranchesResponse
import aws.sdk.kotlin.services.amplify.model.ListDomainAssociationsRequest
import aws.sdk.kotlin.services.amplify.model.ListDomainAssociationsResponse
import aws.sdk.kotlin.services.amplify.model.ListJobsRequest
import aws.sdk.kotlin.services.amplify.model.ListJobsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAppsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAppsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppsResponse]
 */
public fun AmplifyClient.listAppsPaginated(initialRequest: ListAppsRequest = ListAppsRequest { }): Flow<ListAppsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAppsPaginated.listApps(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAppsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAppsResponse]
 */
public fun AmplifyClient.listAppsPaginated(block: ListAppsRequest.Builder.() -> Unit): Flow<ListAppsResponse> =
    listAppsPaginated(ListAppsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAppsPaginated]
 * to access the nested member [App]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [App]
 */
@JvmName("listAppsResponseApp")
public fun Flow<ListAppsResponse>.apps(): Flow<App> =
    transform() { response ->
        response.apps?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListBranchesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListBranchesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBranchesResponse]
 */
public fun AmplifyClient.listBranchesPaginated(initialRequest: ListBranchesRequest): Flow<ListBranchesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listBranchesPaginated.listBranches(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListBranchesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListBranchesResponse]
 */
public fun AmplifyClient.listBranchesPaginated(block: ListBranchesRequest.Builder.() -> Unit): Flow<ListBranchesResponse> =
    listBranchesPaginated(ListBranchesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listBranchesPaginated]
 * to access the nested member [Branch]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Branch]
 */
@JvmName("listBranchesResponseBranch")
public fun Flow<ListBranchesResponse>.branches(): Flow<Branch> =
    transform() { response ->
        response.branches?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListDomainAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListDomainAssociationsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainAssociationsResponse]
 */
public fun AmplifyClient.listDomainAssociationsPaginated(initialRequest: ListDomainAssociationsRequest): Flow<ListDomainAssociationsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listDomainAssociationsPaginated.listDomainAssociations(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListDomainAssociationsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListDomainAssociationsResponse]
 */
public fun AmplifyClient.listDomainAssociationsPaginated(block: ListDomainAssociationsRequest.Builder.() -> Unit): Flow<ListDomainAssociationsResponse> =
    listDomainAssociationsPaginated(ListDomainAssociationsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listDomainAssociationsPaginated]
 * to access the nested member [DomainAssociation]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DomainAssociation]
 */
@JvmName("listDomainAssociationsResponseDomainAssociation")
public fun Flow<ListDomainAssociationsResponse>.domainAssociations(): Flow<DomainAssociation> =
    transform() { response ->
        response.domainAssociations?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListJobsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsResponse]
 */
public fun AmplifyClient.listJobsPaginated(initialRequest: ListJobsRequest): Flow<ListJobsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listJobsPaginated.listJobs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListJobsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListJobsResponse]
 */
public fun AmplifyClient.listJobsPaginated(block: ListJobsRequest.Builder.() -> Unit): Flow<ListJobsResponse> =
    listJobsPaginated(ListJobsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listJobsPaginated]
 * to access the nested member [JobSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [JobSummary]
 */
@JvmName("listJobsResponseJobSummary")
public fun Flow<ListJobsResponse>.jobSummaries(): Flow<JobSummary> =
    transform() { response ->
        response.jobSummaries?.forEach {
            emit(it)
        }
    }
