// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes the configuration details that apply to the jobs for an Amplify app.
 *
 * Use `JobConfig` to apply configuration to jobs, such as customizing the build instance size when you create or update an Amplify app. For more information about customizable build instances, see [Custom build instances](https://docs.aws.amazon.com/amplify/latest/userguide/custom-build-instance.html) in the *Amplify User Guide*.
 */
public class JobConfig private constructor(builder: Builder) {
    /**
     * Specifies the size of the build instance. Amplify supports three instance sizes: `STANDARD_8GB`, `LARGE_16GB`, and `XLARGE_72GB`. If you don't specify a value, Amplify uses the `STANDARD_8GB` default.
     *
     * The following list describes the CPU, memory, and storage capacity for each build instance type:
     *
     * ## STANDARD_8GB
     * + vCPUs: 4
     * + Memory: 8 GiB
     * + Disk space: 128 GB
     *
     * ## LARGE_16GB
     * + vCPUs: 8
     * + Memory: 16 GiB
     * + Disk space: 128 GB
     *
     * ## XLARGE_72GB
     * + vCPUs: 36
     * + Memory: 72 GiB
     * + Disk space: 256 GB
     */
    public val buildComputeType: aws.sdk.kotlin.services.amplify.model.BuildComputeType = requireNotNull(builder.buildComputeType) { "A non-null value must be provided for buildComputeType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.JobConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobConfig(")
        append("buildComputeType=$buildComputeType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = buildComputeType.hashCode()
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobConfig

        if (buildComputeType != other.buildComputeType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.JobConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies the size of the build instance. Amplify supports three instance sizes: `STANDARD_8GB`, `LARGE_16GB`, and `XLARGE_72GB`. If you don't specify a value, Amplify uses the `STANDARD_8GB` default.
         *
         * The following list describes the CPU, memory, and storage capacity for each build instance type:
         *
         * ## STANDARD_8GB
         * + vCPUs: 4
         * + Memory: 8 GiB
         * + Disk space: 128 GB
         *
         * ## LARGE_16GB
         * + vCPUs: 8
         * + Memory: 16 GiB
         * + Disk space: 128 GB
         *
         * ## XLARGE_72GB
         * + vCPUs: 36
         * + Memory: 72 GiB
         * + Disk space: 256 GB
         */
        public var buildComputeType: aws.sdk.kotlin.services.amplify.model.BuildComputeType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.JobConfig) : this() {
            this.buildComputeType = x.buildComputeType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.JobConfig = JobConfig(this)

        internal fun correctErrors(): Builder {
            if (buildComputeType == null) buildComputeType = BuildComputeType.SdkUnknown("no value provided")
            return this
        }
    }
}
