// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.serde

import aws.sdk.kotlin.services.amplify.model.Backend
import aws.sdk.kotlin.services.amplify.model.Stage
import aws.sdk.kotlin.services.amplify.model.UpdateBranchRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateBranchOperationSerializer: HttpSerializer.NonStreaming<UpdateBranchRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateBranchRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.appId) { "appId is bound to the URI and must not be null" }
            requireNotNull(input.branchName) { "branchName is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("apps"))
                add(PercentEncoding.SmithyLabel.encode(input.appId))
                add(PercentEncoding.Path.encode("branches"))
                add(PercentEncoding.SmithyLabel.encode(input.branchName))
            }
        }

        val payload = serializeUpdateBranchOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateBranchOperationBody(context: ExecutionContext, input: UpdateBranchRequest): ByteArray {
    val serializer = JsonSerializer()
    val BACKEND_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("backend"))
    val BACKENDENVIRONMENTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("backendEnvironmentArn"))
    val BASICAUTHCREDENTIALS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("basicAuthCredentials"))
    val BUILDSPEC_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("buildSpec"))
    val COMPUTEROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("computeRoleArn"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val DISPLAYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("displayName"))
    val ENABLEAUTOBUILD_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enableAutoBuild"))
    val ENABLEBASICAUTH_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enableBasicAuth"))
    val ENABLENOTIFICATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enableNotification"))
    val ENABLEPERFORMANCEMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enablePerformanceMode"))
    val ENABLEPULLREQUESTPREVIEW_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enablePullRequestPreview"))
    val ENABLESKEWPROTECTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("enableSkewProtection"))
    val ENVIRONMENTVARIABLES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("environmentVariables"))
    val FRAMEWORK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("framework"))
    val PULLREQUESTENVIRONMENTNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("pullRequestEnvironmentName"))
    val STAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("stage"))
    val TTL_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ttl"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BACKEND_DESCRIPTOR)
        field(BACKENDENVIRONMENTARN_DESCRIPTOR)
        field(BASICAUTHCREDENTIALS_DESCRIPTOR)
        field(BUILDSPEC_DESCRIPTOR)
        field(COMPUTEROLEARN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(DISPLAYNAME_DESCRIPTOR)
        field(ENABLEAUTOBUILD_DESCRIPTOR)
        field(ENABLEBASICAUTH_DESCRIPTOR)
        field(ENABLENOTIFICATION_DESCRIPTOR)
        field(ENABLEPERFORMANCEMODE_DESCRIPTOR)
        field(ENABLEPULLREQUESTPREVIEW_DESCRIPTOR)
        field(ENABLESKEWPROTECTION_DESCRIPTOR)
        field(ENVIRONMENTVARIABLES_DESCRIPTOR)
        field(FRAMEWORK_DESCRIPTOR)
        field(PULLREQUESTENVIRONMENTNAME_DESCRIPTOR)
        field(STAGE_DESCRIPTOR)
        field(TTL_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.backend?.let { field(BACKEND_DESCRIPTOR, it, ::serializeBackendDocument) }
        input.backendEnvironmentArn?.let { field(BACKENDENVIRONMENTARN_DESCRIPTOR, it) }
        input.basicAuthCredentials?.let { field(BASICAUTHCREDENTIALS_DESCRIPTOR, it) }
        input.buildSpec?.let { field(BUILDSPEC_DESCRIPTOR, it) }
        input.computeRoleArn?.let { field(COMPUTEROLEARN_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.displayName?.let { field(DISPLAYNAME_DESCRIPTOR, it) }
        input.enableAutoBuild?.let { field(ENABLEAUTOBUILD_DESCRIPTOR, it) }
        input.enableBasicAuth?.let { field(ENABLEBASICAUTH_DESCRIPTOR, it) }
        input.enableNotification?.let { field(ENABLENOTIFICATION_DESCRIPTOR, it) }
        input.enablePerformanceMode?.let { field(ENABLEPERFORMANCEMODE_DESCRIPTOR, it) }
        input.enablePullRequestPreview?.let { field(ENABLEPULLREQUESTPREVIEW_DESCRIPTOR, it) }
        input.enableSkewProtection?.let { field(ENABLESKEWPROTECTION_DESCRIPTOR, it) }
        if (input.environmentVariables != null) {
            mapField(ENVIRONMENTVARIABLES_DESCRIPTOR) {
                input.environmentVariables.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.framework?.let { field(FRAMEWORK_DESCRIPTOR, it) }
        input.pullRequestEnvironmentName?.let { field(PULLREQUESTENVIRONMENTNAME_DESCRIPTOR, it) }
        input.stage?.let { field(STAGE_DESCRIPTOR, it.value) }
        input.ttl?.let { field(TTL_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
