// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Describes the summary for an execution job for an Amplify app.
 */
public class JobSummary private constructor(builder: Builder) {
    /**
     * The commit ID from a third-party repository provider for the job.
     */
    public val commitId: kotlin.String = requireNotNull(builder.commitId) { "A non-null value must be provided for commitId" }
    /**
     * The commit message from a third-party repository provider for the job.
     */
    public val commitMessage: kotlin.String = requireNotNull(builder.commitMessage) { "A non-null value must be provided for commitMessage" }
    /**
     * The commit date and time for the job.
     */
    public val commitTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.commitTime) { "A non-null value must be provided for commitTime" }
    /**
     * The end date and time for the job.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * The Amazon Resource Name (ARN) for the job.
     */
    public val jobArn: kotlin.String = requireNotNull(builder.jobArn) { "A non-null value must be provided for jobArn" }
    /**
     * The unique ID for the job.
     */
    public val jobId: kotlin.String = requireNotNull(builder.jobId) { "A non-null value must be provided for jobId" }
    /**
     * The type for the job. If the value is `RELEASE`, the job was manually released from its source by using the `StartJob` API. This value is available only for apps that are connected to a repository.
     *
     * If the value is `RETRY`, the job was manually retried using the `StartJob` API. If the value is `WEB_HOOK`, the job was automatically triggered by webhooks. If the value is `MANUAL`, the job is for a manually deployed app. Manually deployed apps are not connected to a Git repository.
     */
    public val jobType: aws.sdk.kotlin.services.amplify.model.JobType = requireNotNull(builder.jobType) { "A non-null value must be provided for jobType" }
    /**
     * The source URL for the files to deploy. The source URL can be either an HTTP GET URL that is publicly accessible and downloads a single .zip file, or an Amazon S3 bucket and prefix.
     */
    public val sourceUrl: kotlin.String? = builder.sourceUrl
    /**
     * The type of source specified by the `sourceURL`. If the value is `ZIP`, the source is a .zip file. If the value is `BUCKET_PREFIX`, the source is an Amazon S3 bucket and prefix. If no value is specified, the default is `ZIP`.
     */
    public val sourceUrlType: aws.sdk.kotlin.services.amplify.model.SourceUrlType? = builder.sourceUrlType
    /**
     * The start date and time for the job.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.startTime) { "A non-null value must be provided for startTime" }
    /**
     * The current status for the job.
     */
    public val status: aws.sdk.kotlin.services.amplify.model.JobStatus = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.JobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JobSummary(")
        append("commitId=$commitId,")
        append("commitMessage=$commitMessage,")
        append("commitTime=$commitTime,")
        append("endTime=$endTime,")
        append("jobArn=$jobArn,")
        append("jobId=$jobId,")
        append("jobType=$jobType,")
        append("sourceUrl=$sourceUrl,")
        append("sourceUrlType=$sourceUrlType,")
        append("startTime=$startTime,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = commitId.hashCode()
        result = 31 * result + (commitMessage.hashCode())
        result = 31 * result + (commitTime.hashCode())
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (jobArn.hashCode())
        result = 31 * result + (jobId.hashCode())
        result = 31 * result + (jobType.hashCode())
        result = 31 * result + (sourceUrl?.hashCode() ?: 0)
        result = 31 * result + (sourceUrlType?.hashCode() ?: 0)
        result = 31 * result + (startTime.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JobSummary

        if (commitId != other.commitId) return false
        if (commitMessage != other.commitMessage) return false
        if (commitTime != other.commitTime) return false
        if (endTime != other.endTime) return false
        if (jobArn != other.jobArn) return false
        if (jobId != other.jobId) return false
        if (jobType != other.jobType) return false
        if (sourceUrl != other.sourceUrl) return false
        if (sourceUrlType != other.sourceUrlType) return false
        if (startTime != other.startTime) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.JobSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The commit ID from a third-party repository provider for the job.
         */
        public var commitId: kotlin.String? = null
        /**
         * The commit message from a third-party repository provider for the job.
         */
        public var commitMessage: kotlin.String? = null
        /**
         * The commit date and time for the job.
         */
        public var commitTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The end date and time for the job.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Amazon Resource Name (ARN) for the job.
         */
        public var jobArn: kotlin.String? = null
        /**
         * The unique ID for the job.
         */
        public var jobId: kotlin.String? = null
        /**
         * The type for the job. If the value is `RELEASE`, the job was manually released from its source by using the `StartJob` API. This value is available only for apps that are connected to a repository.
         *
         * If the value is `RETRY`, the job was manually retried using the `StartJob` API. If the value is `WEB_HOOK`, the job was automatically triggered by webhooks. If the value is `MANUAL`, the job is for a manually deployed app. Manually deployed apps are not connected to a Git repository.
         */
        public var jobType: aws.sdk.kotlin.services.amplify.model.JobType? = null
        /**
         * The source URL for the files to deploy. The source URL can be either an HTTP GET URL that is publicly accessible and downloads a single .zip file, or an Amazon S3 bucket and prefix.
         */
        public var sourceUrl: kotlin.String? = null
        /**
         * The type of source specified by the `sourceURL`. If the value is `ZIP`, the source is a .zip file. If the value is `BUCKET_PREFIX`, the source is an Amazon S3 bucket and prefix. If no value is specified, the default is `ZIP`.
         */
        public var sourceUrlType: aws.sdk.kotlin.services.amplify.model.SourceUrlType? = null
        /**
         * The start date and time for the job.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The current status for the job.
         */
        public var status: aws.sdk.kotlin.services.amplify.model.JobStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.JobSummary) : this() {
            this.commitId = x.commitId
            this.commitMessage = x.commitMessage
            this.commitTime = x.commitTime
            this.endTime = x.endTime
            this.jobArn = x.jobArn
            this.jobId = x.jobId
            this.jobType = x.jobType
            this.sourceUrl = x.sourceUrl
            this.sourceUrlType = x.sourceUrlType
            this.startTime = x.startTime
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.JobSummary = JobSummary(this)

        internal fun correctErrors(): Builder {
            if (commitId == null) commitId = ""
            if (commitMessage == null) commitMessage = ""
            if (commitTime == null) commitTime = Instant.fromEpochSeconds(0)
            if (jobArn == null) jobArn = ""
            if (jobId == null) jobId = ""
            if (jobType == null) jobType = JobType.SdkUnknown("no value provided")
            if (startTime == null) startTime = Instant.fromEpochSeconds(0)
            if (status == null) status = JobStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
