// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Describes a custom rewrite or redirect rule.
 */
public class CustomRule private constructor(builder: Builder) {
    /**
     * The condition for a URL rewrite or redirect rule, such as a country code.
     */
    public val condition: kotlin.String? = builder.condition
    /**
     * The source pattern for a URL rewrite or redirect rule.
     */
    public val source: kotlin.String = requireNotNull(builder.source) { "A non-null value must be provided for source" }
    /**
     * The status code for a URL rewrite or redirect rule.
     *
     * ## 200
     * Represents a 200 rewrite rule.
     *
     * ## 301
     * Represents a 301 (moved permanently) redirect rule. This and all future requests should be directed to the target URL.
     *
     * ## 302
     * Represents a 302 temporary redirect rule.
     *
     * ## 404
     * Represents a 404 redirect rule.
     *
     * ## 404-200
     * Represents a 404 rewrite rule.
     */
    public val status: kotlin.String? = builder.status
    /**
     * The target pattern for a URL rewrite or redirect rule.
     */
    public val target: kotlin.String = requireNotNull(builder.target) { "A non-null value must be provided for target" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.CustomRule = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomRule(")
        append("condition=$condition,")
        append("source=$source,")
        append("status=$status,")
        append("target=$target")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = condition?.hashCode() ?: 0
        result = 31 * result + (source.hashCode())
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (target.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomRule

        if (condition != other.condition) return false
        if (source != other.source) return false
        if (status != other.status) return false
        if (target != other.target) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.CustomRule = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The condition for a URL rewrite or redirect rule, such as a country code.
         */
        public var condition: kotlin.String? = null
        /**
         * The source pattern for a URL rewrite or redirect rule.
         */
        public var source: kotlin.String? = null
        /**
         * The status code for a URL rewrite or redirect rule.
         *
         * ## 200
         * Represents a 200 rewrite rule.
         *
         * ## 301
         * Represents a 301 (moved permanently) redirect rule. This and all future requests should be directed to the target URL.
         *
         * ## 302
         * Represents a 302 temporary redirect rule.
         *
         * ## 404
         * Represents a 404 redirect rule.
         *
         * ## 404-200
         * Represents a 404 rewrite rule.
         */
        public var status: kotlin.String? = null
        /**
         * The target pattern for a URL rewrite or redirect rule.
         */
        public var target: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.CustomRule) : this() {
            this.condition = x.condition
            this.source = x.source
            this.status = x.status
            this.target = x.target
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.CustomRule = CustomRule(this)

        internal fun correctErrors(): Builder {
            if (source == null) source = ""
            if (target == null) target = ""
            return this
        }
    }
}
