// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The request structure for the create branch request.
 */
public class CreateBranchRequest private constructor(builder: Builder) {
    /**
     * The unique ID for an Amplify app.
     */
    public val appId: kotlin.String? = builder.appId
    /**
     * The backend for a `Branch` of an Amplify app. Use for a backend created from an CloudFormation stack.
     *
     * This field is available to Amplify Gen 2 apps only. When you deploy an application with Amplify Gen 2, you provision the app's backend infrastructure using Typescript code.
     */
    public val backend: aws.sdk.kotlin.services.amplify.model.Backend? = builder.backend
    /**
     * The Amazon Resource Name (ARN) for a backend environment that is part of a Gen 1 Amplify app.
     *
     * This field is available to Amplify Gen 1 apps only where the backend is created using Amplify Studio or the Amplify command line interface (CLI).
     */
    public val backendEnvironmentArn: kotlin.String? = builder.backendEnvironmentArn
    /**
     * The basic authorization credentials for the branch. You must base64-encode the authorization credentials and provide them in the format `user:password`.
     */
    public val basicAuthCredentials: kotlin.String? = builder.basicAuthCredentials
    /**
     * The name for the branch.
     */
    public val branchName: kotlin.String? = builder.branchName
    /**
     * The build specification (build spec) for the branch.
     */
    public val buildSpec: kotlin.String? = builder.buildSpec
    /**
     * The Amazon Resource Name (ARN) of the IAM role to assign to a branch of an SSR app. The SSR Compute role allows the Amplify Hosting compute service to securely access specific Amazon Web Services resources based on the role's permissions. For more information about the SSR Compute role, see [Adding an SSR Compute role](https://docs.aws.amazon.com/amplify/latest/userguide/amplify-SSR-compute-role.html) in the *Amplify User Guide*.
     */
    public val computeRoleArn: kotlin.String? = builder.computeRoleArn
    /**
     * The description for the branch.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The display name for a branch. This is used as the default domain prefix.
     */
    public val displayName: kotlin.String? = builder.displayName
    /**
     * Enables auto building for the branch.
     */
    public val enableAutoBuild: kotlin.Boolean? = builder.enableAutoBuild
    /**
     * Enables basic authorization for the branch.
     */
    public val enableBasicAuth: kotlin.Boolean? = builder.enableBasicAuth
    /**
     * Enables notifications for the branch.
     */
    public val enableNotification: kotlin.Boolean? = builder.enableNotification
    /**
     * Enables performance mode for the branch.
     *
     * Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out.
     */
    public val enablePerformanceMode: kotlin.Boolean? = builder.enablePerformanceMode
    /**
     * Enables pull request previews for this branch.
     */
    public val enablePullRequestPreview: kotlin.Boolean? = builder.enablePullRequestPreview
    /**
     * Specifies whether the skew protection feature is enabled for the branch.
     *
     * Deployment skew protection is available to Amplify applications to eliminate version skew issues between client and servers in web applications. When you apply skew protection to a branch, you can ensure that your clients always interact with the correct version of server-side assets, regardless of when a deployment occurs. For more information about skew protection, see [Skew protection for Amplify deployments](https://docs.aws.amazon.com/amplify/latest/userguide/skew-protection.html) in the *Amplify User Guide*.
     */
    public val enableSkewProtection: kotlin.Boolean? = builder.enableSkewProtection
    /**
     * The environment variables for the branch.
     */
    public val environmentVariables: Map<String, String>? = builder.environmentVariables
    /**
     * The framework for the branch.
     */
    public val framework: kotlin.String? = builder.framework
    /**
     * The Amplify environment name for the pull request.
     */
    public val pullRequestEnvironmentName: kotlin.String? = builder.pullRequestEnvironmentName
    /**
     * Describes the current stage for the branch.
     */
    public val stage: aws.sdk.kotlin.services.amplify.model.Stage? = builder.stage
    /**
     * The tag for the branch.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The content Time To Live (TTL) for the website in seconds.
     */
    public val ttl: kotlin.String? = builder.ttl

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.CreateBranchRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateBranchRequest(")
        append("appId=$appId,")
        append("backend=$backend,")
        append("backendEnvironmentArn=$backendEnvironmentArn,")
        append("basicAuthCredentials=*** Sensitive Data Redacted ***,")
        append("branchName=$branchName,")
        append("buildSpec=*** Sensitive Data Redacted ***,")
        append("computeRoleArn=$computeRoleArn,")
        append("description=$description,")
        append("displayName=$displayName,")
        append("enableAutoBuild=$enableAutoBuild,")
        append("enableBasicAuth=$enableBasicAuth,")
        append("enableNotification=$enableNotification,")
        append("enablePerformanceMode=$enablePerformanceMode,")
        append("enablePullRequestPreview=$enablePullRequestPreview,")
        append("enableSkewProtection=$enableSkewProtection,")
        append("environmentVariables=$environmentVariables,")
        append("framework=$framework,")
        append("pullRequestEnvironmentName=$pullRequestEnvironmentName,")
        append("stage=$stage,")
        append("tags=$tags,")
        append("ttl=$ttl")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appId?.hashCode() ?: 0
        result = 31 * result + (backend?.hashCode() ?: 0)
        result = 31 * result + (backendEnvironmentArn?.hashCode() ?: 0)
        result = 31 * result + (basicAuthCredentials?.hashCode() ?: 0)
        result = 31 * result + (branchName?.hashCode() ?: 0)
        result = 31 * result + (buildSpec?.hashCode() ?: 0)
        result = 31 * result + (computeRoleArn?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (displayName?.hashCode() ?: 0)
        result = 31 * result + (enableAutoBuild?.hashCode() ?: 0)
        result = 31 * result + (enableBasicAuth?.hashCode() ?: 0)
        result = 31 * result + (enableNotification?.hashCode() ?: 0)
        result = 31 * result + (enablePerformanceMode?.hashCode() ?: 0)
        result = 31 * result + (enablePullRequestPreview?.hashCode() ?: 0)
        result = 31 * result + (enableSkewProtection?.hashCode() ?: 0)
        result = 31 * result + (environmentVariables?.hashCode() ?: 0)
        result = 31 * result + (framework?.hashCode() ?: 0)
        result = 31 * result + (pullRequestEnvironmentName?.hashCode() ?: 0)
        result = 31 * result + (stage?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (ttl?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateBranchRequest

        if (appId != other.appId) return false
        if (backend != other.backend) return false
        if (backendEnvironmentArn != other.backendEnvironmentArn) return false
        if (basicAuthCredentials != other.basicAuthCredentials) return false
        if (branchName != other.branchName) return false
        if (buildSpec != other.buildSpec) return false
        if (computeRoleArn != other.computeRoleArn) return false
        if (description != other.description) return false
        if (displayName != other.displayName) return false
        if (enableAutoBuild != other.enableAutoBuild) return false
        if (enableBasicAuth != other.enableBasicAuth) return false
        if (enableNotification != other.enableNotification) return false
        if (enablePerformanceMode != other.enablePerformanceMode) return false
        if (enablePullRequestPreview != other.enablePullRequestPreview) return false
        if (enableSkewProtection != other.enableSkewProtection) return false
        if (environmentVariables != other.environmentVariables) return false
        if (framework != other.framework) return false
        if (pullRequestEnvironmentName != other.pullRequestEnvironmentName) return false
        if (stage != other.stage) return false
        if (tags != other.tags) return false
        if (ttl != other.ttl) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.CreateBranchRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique ID for an Amplify app.
         */
        public var appId: kotlin.String? = null
        /**
         * The backend for a `Branch` of an Amplify app. Use for a backend created from an CloudFormation stack.
         *
         * This field is available to Amplify Gen 2 apps only. When you deploy an application with Amplify Gen 2, you provision the app's backend infrastructure using Typescript code.
         */
        public var backend: aws.sdk.kotlin.services.amplify.model.Backend? = null
        /**
         * The Amazon Resource Name (ARN) for a backend environment that is part of a Gen 1 Amplify app.
         *
         * This field is available to Amplify Gen 1 apps only where the backend is created using Amplify Studio or the Amplify command line interface (CLI).
         */
        public var backendEnvironmentArn: kotlin.String? = null
        /**
         * The basic authorization credentials for the branch. You must base64-encode the authorization credentials and provide them in the format `user:password`.
         */
        public var basicAuthCredentials: kotlin.String? = null
        /**
         * The name for the branch.
         */
        public var branchName: kotlin.String? = null
        /**
         * The build specification (build spec) for the branch.
         */
        public var buildSpec: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role to assign to a branch of an SSR app. The SSR Compute role allows the Amplify Hosting compute service to securely access specific Amazon Web Services resources based on the role's permissions. For more information about the SSR Compute role, see [Adding an SSR Compute role](https://docs.aws.amazon.com/amplify/latest/userguide/amplify-SSR-compute-role.html) in the *Amplify User Guide*.
         */
        public var computeRoleArn: kotlin.String? = null
        /**
         * The description for the branch.
         */
        public var description: kotlin.String? = null
        /**
         * The display name for a branch. This is used as the default domain prefix.
         */
        public var displayName: kotlin.String? = null
        /**
         * Enables auto building for the branch.
         */
        public var enableAutoBuild: kotlin.Boolean? = null
        /**
         * Enables basic authorization for the branch.
         */
        public var enableBasicAuth: kotlin.Boolean? = null
        /**
         * Enables notifications for the branch.
         */
        public var enableNotification: kotlin.Boolean? = null
        /**
         * Enables performance mode for the branch.
         *
         * Performance mode optimizes for faster hosting performance by keeping content cached at the edge for a longer interval. When performance mode is enabled, hosting configuration or code changes can take up to 10 minutes to roll out.
         */
        public var enablePerformanceMode: kotlin.Boolean? = null
        /**
         * Enables pull request previews for this branch.
         */
        public var enablePullRequestPreview: kotlin.Boolean? = null
        /**
         * Specifies whether the skew protection feature is enabled for the branch.
         *
         * Deployment skew protection is available to Amplify applications to eliminate version skew issues between client and servers in web applications. When you apply skew protection to a branch, you can ensure that your clients always interact with the correct version of server-side assets, regardless of when a deployment occurs. For more information about skew protection, see [Skew protection for Amplify deployments](https://docs.aws.amazon.com/amplify/latest/userguide/skew-protection.html) in the *Amplify User Guide*.
         */
        public var enableSkewProtection: kotlin.Boolean? = null
        /**
         * The environment variables for the branch.
         */
        public var environmentVariables: Map<String, String>? = null
        /**
         * The framework for the branch.
         */
        public var framework: kotlin.String? = null
        /**
         * The Amplify environment name for the pull request.
         */
        public var pullRequestEnvironmentName: kotlin.String? = null
        /**
         * Describes the current stage for the branch.
         */
        public var stage: aws.sdk.kotlin.services.amplify.model.Stage? = null
        /**
         * The tag for the branch.
         */
        public var tags: Map<String, String>? = null
        /**
         * The content Time To Live (TTL) for the website in seconds.
         */
        public var ttl: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.CreateBranchRequest) : this() {
            this.appId = x.appId
            this.backend = x.backend
            this.backendEnvironmentArn = x.backendEnvironmentArn
            this.basicAuthCredentials = x.basicAuthCredentials
            this.branchName = x.branchName
            this.buildSpec = x.buildSpec
            this.computeRoleArn = x.computeRoleArn
            this.description = x.description
            this.displayName = x.displayName
            this.enableAutoBuild = x.enableAutoBuild
            this.enableBasicAuth = x.enableBasicAuth
            this.enableNotification = x.enableNotification
            this.enablePerformanceMode = x.enablePerformanceMode
            this.enablePullRequestPreview = x.enablePullRequestPreview
            this.enableSkewProtection = x.enableSkewProtection
            this.environmentVariables = x.environmentVariables
            this.framework = x.framework
            this.pullRequestEnvironmentName = x.pullRequestEnvironmentName
            this.stage = x.stage
            this.tags = x.tags
            this.ttl = x.ttl
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.CreateBranchRequest = CreateBranchRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.amplify.model.Backend] inside the given [block]
         */
        public fun backend(block: aws.sdk.kotlin.services.amplify.model.Backend.Builder.() -> kotlin.Unit) {
            this.backend = aws.sdk.kotlin.services.amplify.model.Backend.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
