// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The type of SSL/TLS certificate to use for your custom domain. If a certificate type isn't specified, Amplify uses the default `AMPLIFY_MANAGED` certificate.
 */
public class CertificateSettings private constructor(builder: Builder) {
    /**
     * The Amazon resource name (ARN) for the custom certificate that you have already added to Certificate Manager in your Amazon Web Services account.
     *
     * This field is required only when the certificate type is `CUSTOM`.
     */
    public val customCertificateArn: kotlin.String? = builder.customCertificateArn
    /**
     * The certificate type.
     *
     * Specify `AMPLIFY_MANAGED` to use the default certificate that Amplify provisions for you.
     *
     * Specify `CUSTOM` to use your own certificate that you have already added to Certificate Manager in your Amazon Web Services account. Make sure you request (or import) the certificate in the US East (N. Virginia) Region (us-east-1). For more information about using ACM, see [Importing certificates into Certificate Manager](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the *ACM User guide*.
     */
    public val type: aws.sdk.kotlin.services.amplify.model.CertificateType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.CertificateSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CertificateSettings(")
        append("customCertificateArn=$customCertificateArn,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = customCertificateArn?.hashCode() ?: 0
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CertificateSettings

        if (customCertificateArn != other.customCertificateArn) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.CertificateSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon resource name (ARN) for the custom certificate that you have already added to Certificate Manager in your Amazon Web Services account.
         *
         * This field is required only when the certificate type is `CUSTOM`.
         */
        public var customCertificateArn: kotlin.String? = null
        /**
         * The certificate type.
         *
         * Specify `AMPLIFY_MANAGED` to use the default certificate that Amplify provisions for you.
         *
         * Specify `CUSTOM` to use your own certificate that you have already added to Certificate Manager in your Amazon Web Services account. Make sure you request (or import) the certificate in the US East (N. Virginia) Region (us-east-1). For more information about using ACM, see [Importing certificates into Certificate Manager](https://docs.aws.amazon.com/acm/latest/userguide/import-certificate.html) in the *ACM User guide*.
         */
        public var type: aws.sdk.kotlin.services.amplify.model.CertificateType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.CertificateSettings) : this() {
            this.customCertificateArn = x.customCertificateArn
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.CertificateSettings = CertificateSettings(this)

        internal fun correctErrors(): Builder {
            if (type == null) type = CertificateType.SdkUnknown("no value provided")
            return this
        }
    }
}
