// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.amplify.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Represents the different branches of a repository for building, deploying, and hosting an Amplify app.
 */
public class App private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the Amplify app.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * The unique ID of the Amplify app.
     */
    public val appId: kotlin.String = requireNotNull(builder.appId) { "A non-null value must be provided for appId" }
    /**
     * Describes the automated branch creation configuration for the Amplify app.
     */
    public val autoBranchCreationConfig: aws.sdk.kotlin.services.amplify.model.AutoBranchCreationConfig? = builder.autoBranchCreationConfig
    /**
     * Describes the automated branch creation glob patterns for the Amplify app.
     */
    public val autoBranchCreationPatterns: List<String>? = builder.autoBranchCreationPatterns
    /**
     * The basic authorization credentials for branches for the Amplify app. You must base64-encode the authorization credentials and provide them in the format `user:password`.
     */
    public val basicAuthCredentials: kotlin.String? = builder.basicAuthCredentials
    /**
     * Describes the content of the build specification (build spec) for the Amplify app.
     */
    public val buildSpec: kotlin.String? = builder.buildSpec
    /**
     * The cache configuration for the Amplify app. If you don't specify the cache configuration `type`, Amplify uses the default `AMPLIFY_MANAGED` setting.
     */
    public val cacheConfig: aws.sdk.kotlin.services.amplify.model.CacheConfig? = builder.cacheConfig
    /**
     * The Amazon Resource Name (ARN) of the IAM role for an SSR app. The Compute role allows the Amplify Hosting compute service to securely access specific Amazon Web Services resources based on the role's permissions. For more information about the SSR Compute role, see [Adding an SSR Compute role](https://docs.aws.amazon.com/amplify/latest/userguide/amplify-SSR-compute-role.html) in the *Amplify User Guide*.
     */
    public val computeRoleArn: kotlin.String? = builder.computeRoleArn
    /**
     * A timestamp of when Amplify created the application.
     */
    public val createTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createTime) { "A non-null value must be provided for createTime" }
    /**
     * Describes the custom HTTP headers for the Amplify app.
     */
    public val customHeaders: kotlin.String? = builder.customHeaders
    /**
     * Describes the custom redirect and rewrite rules for the Amplify app.
     */
    public val customRules: List<CustomRule>? = builder.customRules
    /**
     * The default domain for the Amplify app.
     */
    public val defaultDomain: kotlin.String = requireNotNull(builder.defaultDomain) { "A non-null value must be provided for defaultDomain" }
    /**
     * The description for the Amplify app.
     */
    public val description: kotlin.String = requireNotNull(builder.description) { "A non-null value must be provided for description" }
    /**
     * Enables automated branch creation for the Amplify app.
     */
    public val enableAutoBranchCreation: kotlin.Boolean? = builder.enableAutoBranchCreation
    /**
     * Enables basic authorization for the Amplify app's branches.
     */
    public val enableBasicAuth: kotlin.Boolean = requireNotNull(builder.enableBasicAuth) { "A non-null value must be provided for enableBasicAuth" }
    /**
     * Enables the auto-building of branches for the Amplify app.
     */
    public val enableBranchAutoBuild: kotlin.Boolean = requireNotNull(builder.enableBranchAutoBuild) { "A non-null value must be provided for enableBranchAutoBuild" }
    /**
     * Automatically disconnect a branch in the Amplify console when you delete a branch from your Git repository.
     */
    public val enableBranchAutoDeletion: kotlin.Boolean? = builder.enableBranchAutoDeletion
    /**
     * The environment variables for the Amplify app.
     *
     * For a list of the environment variables that are accessible to Amplify by default, see [Amplify Environment variables](https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html) in the *Amplify Hosting User Guide*.
     */
    public val environmentVariables: Map<String, String> = requireNotNull(builder.environmentVariables) { "A non-null value must be provided for environmentVariables" }
    /**
     * The Amazon Resource Name (ARN) of the IAM service role for the Amplify app.
     */
    public val iamServiceRoleArn: kotlin.String? = builder.iamServiceRoleArn
    /**
     * The name for the Amplify app.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The platform for the Amplify app. For a static app, set the platform type to `WEB`. For a dynamic server-side rendered (SSR) app, set the platform type to `WEB_COMPUTE`. For an app requiring Amplify Hosting's original SSR support only, set the platform type to `WEB_DYNAMIC`.
     *
     * If you are deploying an SSG only app with Next.js 14 or later, you must use the platform type `WEB_COMPUTE`.
     */
    public val platform: aws.sdk.kotlin.services.amplify.model.Platform = requireNotNull(builder.platform) { "A non-null value must be provided for platform" }
    /**
     * Describes the information about a production branch of the Amplify app.
     */
    public val productionBranch: aws.sdk.kotlin.services.amplify.model.ProductionBranch? = builder.productionBranch
    /**
     * The Git repository for the Amplify app.
     */
    public val repository: kotlin.String = requireNotNull(builder.repository) { "A non-null value must be provided for repository" }
    /**
     * This is for internal use.
     *
     * The Amplify service uses this parameter to specify the authentication protocol to use to access the Git repository for an Amplify app. Amplify specifies `TOKEN` for a GitHub repository, `SIGV4` for an Amazon Web Services CodeCommit repository, and `SSH` for GitLab and Bitbucket repositories.
     */
    public val repositoryCloneMethod: aws.sdk.kotlin.services.amplify.model.RepositoryCloneMethod? = builder.repositoryCloneMethod
    /**
     * The tag for the Amplify app.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A timestamp of when Amplify updated the application.
     */
    public val updateTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.updateTime) { "A non-null value must be provided for updateTime" }
    /**
     * Describes the Firewall configuration for the Amplify app. Firewall support enables you to protect your hosted applications with a direct integration with WAF.
     */
    public val wafConfiguration: aws.sdk.kotlin.services.amplify.model.WafConfiguration? = builder.wafConfiguration
    /**
     * A timestamp of when Amplify created the webhook in your Git repository.
     */
    public val webhookCreateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.webhookCreateTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.amplify.model.App = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("App(")
        append("appArn=$appArn,")
        append("appId=$appId,")
        append("autoBranchCreationConfig=$autoBranchCreationConfig,")
        append("autoBranchCreationPatterns=$autoBranchCreationPatterns,")
        append("basicAuthCredentials=*** Sensitive Data Redacted ***,")
        append("buildSpec=*** Sensitive Data Redacted ***,")
        append("cacheConfig=$cacheConfig,")
        append("computeRoleArn=$computeRoleArn,")
        append("createTime=$createTime,")
        append("customHeaders=$customHeaders,")
        append("customRules=$customRules,")
        append("defaultDomain=$defaultDomain,")
        append("description=$description,")
        append("enableAutoBranchCreation=$enableAutoBranchCreation,")
        append("enableBasicAuth=$enableBasicAuth,")
        append("enableBranchAutoBuild=$enableBranchAutoBuild,")
        append("enableBranchAutoDeletion=$enableBranchAutoDeletion,")
        append("environmentVariables=$environmentVariables,")
        append("iamServiceRoleArn=$iamServiceRoleArn,")
        append("name=$name,")
        append("platform=$platform,")
        append("productionBranch=$productionBranch,")
        append("repository=$repository,")
        append("repositoryCloneMethod=$repositoryCloneMethod,")
        append("tags=$tags,")
        append("updateTime=$updateTime,")
        append("wafConfiguration=$wafConfiguration,")
        append("webhookCreateTime=$webhookCreateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn.hashCode()
        result = 31 * result + (appId.hashCode())
        result = 31 * result + (autoBranchCreationConfig?.hashCode() ?: 0)
        result = 31 * result + (autoBranchCreationPatterns?.hashCode() ?: 0)
        result = 31 * result + (basicAuthCredentials?.hashCode() ?: 0)
        result = 31 * result + (buildSpec?.hashCode() ?: 0)
        result = 31 * result + (cacheConfig?.hashCode() ?: 0)
        result = 31 * result + (computeRoleArn?.hashCode() ?: 0)
        result = 31 * result + (createTime.hashCode())
        result = 31 * result + (customHeaders?.hashCode() ?: 0)
        result = 31 * result + (customRules?.hashCode() ?: 0)
        result = 31 * result + (defaultDomain.hashCode())
        result = 31 * result + (description.hashCode())
        result = 31 * result + (enableAutoBranchCreation?.hashCode() ?: 0)
        result = 31 * result + (enableBasicAuth.hashCode())
        result = 31 * result + (enableBranchAutoBuild.hashCode())
        result = 31 * result + (enableBranchAutoDeletion?.hashCode() ?: 0)
        result = 31 * result + (environmentVariables.hashCode())
        result = 31 * result + (iamServiceRoleArn?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (platform.hashCode())
        result = 31 * result + (productionBranch?.hashCode() ?: 0)
        result = 31 * result + (repository.hashCode())
        result = 31 * result + (repositoryCloneMethod?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (updateTime.hashCode())
        result = 31 * result + (wafConfiguration?.hashCode() ?: 0)
        result = 31 * result + (webhookCreateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as App

        if (appArn != other.appArn) return false
        if (appId != other.appId) return false
        if (autoBranchCreationConfig != other.autoBranchCreationConfig) return false
        if (autoBranchCreationPatterns != other.autoBranchCreationPatterns) return false
        if (basicAuthCredentials != other.basicAuthCredentials) return false
        if (buildSpec != other.buildSpec) return false
        if (cacheConfig != other.cacheConfig) return false
        if (computeRoleArn != other.computeRoleArn) return false
        if (createTime != other.createTime) return false
        if (customHeaders != other.customHeaders) return false
        if (customRules != other.customRules) return false
        if (defaultDomain != other.defaultDomain) return false
        if (description != other.description) return false
        if (enableAutoBranchCreation != other.enableAutoBranchCreation) return false
        if (enableBasicAuth != other.enableBasicAuth) return false
        if (enableBranchAutoBuild != other.enableBranchAutoBuild) return false
        if (enableBranchAutoDeletion != other.enableBranchAutoDeletion) return false
        if (environmentVariables != other.environmentVariables) return false
        if (iamServiceRoleArn != other.iamServiceRoleArn) return false
        if (name != other.name) return false
        if (platform != other.platform) return false
        if (productionBranch != other.productionBranch) return false
        if (repository != other.repository) return false
        if (repositoryCloneMethod != other.repositoryCloneMethod) return false
        if (tags != other.tags) return false
        if (updateTime != other.updateTime) return false
        if (wafConfiguration != other.wafConfiguration) return false
        if (webhookCreateTime != other.webhookCreateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.amplify.model.App = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the Amplify app.
         */
        public var appArn: kotlin.String? = null
        /**
         * The unique ID of the Amplify app.
         */
        public var appId: kotlin.String? = null
        /**
         * Describes the automated branch creation configuration for the Amplify app.
         */
        public var autoBranchCreationConfig: aws.sdk.kotlin.services.amplify.model.AutoBranchCreationConfig? = null
        /**
         * Describes the automated branch creation glob patterns for the Amplify app.
         */
        public var autoBranchCreationPatterns: List<String>? = null
        /**
         * The basic authorization credentials for branches for the Amplify app. You must base64-encode the authorization credentials and provide them in the format `user:password`.
         */
        public var basicAuthCredentials: kotlin.String? = null
        /**
         * Describes the content of the build specification (build spec) for the Amplify app.
         */
        public var buildSpec: kotlin.String? = null
        /**
         * The cache configuration for the Amplify app. If you don't specify the cache configuration `type`, Amplify uses the default `AMPLIFY_MANAGED` setting.
         */
        public var cacheConfig: aws.sdk.kotlin.services.amplify.model.CacheConfig? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role for an SSR app. The Compute role allows the Amplify Hosting compute service to securely access specific Amazon Web Services resources based on the role's permissions. For more information about the SSR Compute role, see [Adding an SSR Compute role](https://docs.aws.amazon.com/amplify/latest/userguide/amplify-SSR-compute-role.html) in the *Amplify User Guide*.
         */
        public var computeRoleArn: kotlin.String? = null
        /**
         * A timestamp of when Amplify created the application.
         */
        public var createTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Describes the custom HTTP headers for the Amplify app.
         */
        public var customHeaders: kotlin.String? = null
        /**
         * Describes the custom redirect and rewrite rules for the Amplify app.
         */
        public var customRules: List<CustomRule>? = null
        /**
         * The default domain for the Amplify app.
         */
        public var defaultDomain: kotlin.String? = null
        /**
         * The description for the Amplify app.
         */
        public var description: kotlin.String? = null
        /**
         * Enables automated branch creation for the Amplify app.
         */
        public var enableAutoBranchCreation: kotlin.Boolean? = null
        /**
         * Enables basic authorization for the Amplify app's branches.
         */
        public var enableBasicAuth: kotlin.Boolean? = null
        /**
         * Enables the auto-building of branches for the Amplify app.
         */
        public var enableBranchAutoBuild: kotlin.Boolean? = null
        /**
         * Automatically disconnect a branch in the Amplify console when you delete a branch from your Git repository.
         */
        public var enableBranchAutoDeletion: kotlin.Boolean? = null
        /**
         * The environment variables for the Amplify app.
         *
         * For a list of the environment variables that are accessible to Amplify by default, see [Amplify Environment variables](https://docs.aws.amazon.com/amplify/latest/userguide/amplify-console-environment-variables.html) in the *Amplify Hosting User Guide*.
         */
        public var environmentVariables: Map<String, String>? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM service role for the Amplify app.
         */
        public var iamServiceRoleArn: kotlin.String? = null
        /**
         * The name for the Amplify app.
         */
        public var name: kotlin.String? = null
        /**
         * The platform for the Amplify app. For a static app, set the platform type to `WEB`. For a dynamic server-side rendered (SSR) app, set the platform type to `WEB_COMPUTE`. For an app requiring Amplify Hosting's original SSR support only, set the platform type to `WEB_DYNAMIC`.
         *
         * If you are deploying an SSG only app with Next.js 14 or later, you must use the platform type `WEB_COMPUTE`.
         */
        public var platform: aws.sdk.kotlin.services.amplify.model.Platform? = null
        /**
         * Describes the information about a production branch of the Amplify app.
         */
        public var productionBranch: aws.sdk.kotlin.services.amplify.model.ProductionBranch? = null
        /**
         * The Git repository for the Amplify app.
         */
        public var repository: kotlin.String? = null
        /**
         * This is for internal use.
         *
         * The Amplify service uses this parameter to specify the authentication protocol to use to access the Git repository for an Amplify app. Amplify specifies `TOKEN` for a GitHub repository, `SIGV4` for an Amazon Web Services CodeCommit repository, and `SSH` for GitLab and Bitbucket repositories.
         */
        public var repositoryCloneMethod: aws.sdk.kotlin.services.amplify.model.RepositoryCloneMethod? = null
        /**
         * The tag for the Amplify app.
         */
        public var tags: Map<String, String>? = null
        /**
         * A timestamp of when Amplify updated the application.
         */
        public var updateTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Describes the Firewall configuration for the Amplify app. Firewall support enables you to protect your hosted applications with a direct integration with WAF.
         */
        public var wafConfiguration: aws.sdk.kotlin.services.amplify.model.WafConfiguration? = null
        /**
         * A timestamp of when Amplify created the webhook in your Git repository.
         */
        public var webhookCreateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.amplify.model.App) : this() {
            this.appArn = x.appArn
            this.appId = x.appId
            this.autoBranchCreationConfig = x.autoBranchCreationConfig
            this.autoBranchCreationPatterns = x.autoBranchCreationPatterns
            this.basicAuthCredentials = x.basicAuthCredentials
            this.buildSpec = x.buildSpec
            this.cacheConfig = x.cacheConfig
            this.computeRoleArn = x.computeRoleArn
            this.createTime = x.createTime
            this.customHeaders = x.customHeaders
            this.customRules = x.customRules
            this.defaultDomain = x.defaultDomain
            this.description = x.description
            this.enableAutoBranchCreation = x.enableAutoBranchCreation
            this.enableBasicAuth = x.enableBasicAuth
            this.enableBranchAutoBuild = x.enableBranchAutoBuild
            this.enableBranchAutoDeletion = x.enableBranchAutoDeletion
            this.environmentVariables = x.environmentVariables
            this.iamServiceRoleArn = x.iamServiceRoleArn
            this.name = x.name
            this.platform = x.platform
            this.productionBranch = x.productionBranch
            this.repository = x.repository
            this.repositoryCloneMethod = x.repositoryCloneMethod
            this.tags = x.tags
            this.updateTime = x.updateTime
            this.wafConfiguration = x.wafConfiguration
            this.webhookCreateTime = x.webhookCreateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.amplify.model.App = App(this)

        /**
         * construct an [aws.sdk.kotlin.services.amplify.model.AutoBranchCreationConfig] inside the given [block]
         */
        public fun autoBranchCreationConfig(block: aws.sdk.kotlin.services.amplify.model.AutoBranchCreationConfig.Builder.() -> kotlin.Unit) {
            this.autoBranchCreationConfig = aws.sdk.kotlin.services.amplify.model.AutoBranchCreationConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.amplify.model.CacheConfig] inside the given [block]
         */
        public fun cacheConfig(block: aws.sdk.kotlin.services.amplify.model.CacheConfig.Builder.() -> kotlin.Unit) {
            this.cacheConfig = aws.sdk.kotlin.services.amplify.model.CacheConfig.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.amplify.model.ProductionBranch] inside the given [block]
         */
        public fun productionBranch(block: aws.sdk.kotlin.services.amplify.model.ProductionBranch.Builder.() -> kotlin.Unit) {
            this.productionBranch = aws.sdk.kotlin.services.amplify.model.ProductionBranch.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.amplify.model.WafConfiguration] inside the given [block]
         */
        public fun wafConfiguration(block: aws.sdk.kotlin.services.amplify.model.WafConfiguration.Builder.() -> kotlin.Unit) {
            this.wafConfiguration = aws.sdk.kotlin.services.amplify.model.WafConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            if (appId == null) appId = ""
            if (createTime == null) createTime = Instant.fromEpochSeconds(0)
            if (defaultDomain == null) defaultDomain = ""
            if (description == null) description = ""
            if (enableBasicAuth == null) enableBasicAuth = false
            if (enableBranchAutoBuild == null) enableBranchAutoBuild = false
            if (environmentVariables == null) environmentVariables = emptyMap()
            if (name == null) name = ""
            if (platform == null) platform = Platform.SdkUnknown("no value provided")
            if (repository == null) repository = ""
            if (updateTime == null) updateTime = Instant.fromEpochSeconds(0)
            return this
        }
    }
}
